/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationVisitor
implements Consumer<Pair<ComponentAst, List<ComponentAst>>> {
    public static final ComponentIdentifier BATCH_JOB_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:job");
    public static final ComponentIdentifier BATCH_PROCESSS_RECORDS_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:process-records");
    private static final ComponentIdentifier BATCH_ON_COMPLETE_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:on-complete");
    private static final ComponentIdentifier BATCH_STEP_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:step");
    private static final ComponentIdentifier BATCH_AGGREGATOR_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"batch:aggregator");
    private static final String PROCESSORS_PART_NAME = "processors";
    private static final String SOURCE_PART_NAME = "source";
    private static final ComponentIdentifier ROUTE_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"mule:route");
    private static final ComponentIdentifier CHOICE_WHEN_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"mule:when");
    private static final ComponentIdentifier CHOICE_OTHERWISE_COMPONENT_IDENTIFIER = ComponentIdentifier.buildFromStringRepresentation((String)"mule:otherwise");

    @Override
    public void accept(Pair<ComponentAst, List<ComponentAst>> item) {
        this.accept((ComponentAst)item.getFirst(), (List)item.getSecond());
    }

    public void accept(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        DefaultComponentLocation componentLocation;
        if (((ComponentModel)componentModel).getParent() == null) {
            return;
        }
        Optional<TypedComponentIdentifier> typedComponentIdentifier = Optional.of(TypedComponentIdentifier.builder().identifier(componentModel.getIdentifier()).type(componentModel.getComponentType()).build());
        if (((ComponentModel)componentModel).isRoot()) {
            String componentModelNameAttribute = componentModel.getComponentId().orElse(null);
            ImmutableList parts = ImmutableList.builder().add((Object)new DefaultComponentLocation.DefaultLocationPart(componentModelNameAttribute, typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn())).build();
            componentLocation = new DefaultComponentLocation(Optional.ofNullable(componentModelNameAttribute), (List)parts);
        } else if (this.existsWithinRootContainer(componentModel, hierarchy)) {
            ComponentAst parentComponentModel = componentModel.getIdentifier().equals(ApplicationModel.REDELIVERY_POLICY_IDENTIFIER) ? hierarchy.get(hierarchy.size() - 1).directChildrenStream().findFirst().orElse(hierarchy.get(hierarchy.size() - 1)) : hierarchy.get(hierarchy.size() - 1);
            DefaultComponentLocation parentComponentLocation = (DefaultComponentLocation)parentComponentModel.getLocation();
            componentLocation = this.isHttpProxyPart(componentModel) ? parentComponentLocation.appendLocationPart(componentModel.getIdentifier().getName(), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (this.isRootProcessorScope(parentComponentModel) ? this.processFlowDirectChild(componentModel, hierarchy, parentComponentLocation, typedComponentIdentifier) : (this.isMunitFlowIdentifier(parentComponentModel) ? parentComponentLocation.appendRoutePart().appendLocationPart(this.findNonProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (ComponentModelHelper.isErrorHandler(componentModel) ? this.processErrorHandlerComponent(componentModel, parentComponentLocation, typedComponentIdentifier) : (ComponentModelHelper.isTemplateOnErrorHandler(componentModel) ? this.processOnErrorModel(componentModel, hierarchy, parentComponentLocation, typedComponentIdentifier) : (this.parentComponentIsRouter(componentModel, hierarchy) ? (this.isRoute(componentModel) ? parentComponentLocation.appendRoutePart().appendLocationPart(this.findRoutePath(componentModel, hierarchy), Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.SCOPE).identifier(ROUTE_COMPONENT_IDENTIFIER).build()), componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (ComponentModelHelper.isProcessor(componentModel) ? parentComponentLocation.appendRoutePart().appendLocationPart(this.findProcessorPath(componentModel, hierarchy), Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendProcessorsPart().appendLocationPart("0", typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()))) : (ComponentModelHelper.isProcessor(componentModel) ? (this.isModuleOperation(parentComponentModel) ? this.processModuleOperationChildren(componentModel, hierarchy, typedComponentIdentifier) : parentComponentLocation.appendProcessorsPart().appendLocationPart(this.findProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn())) : (this.isConnection(componentModel) ? parentComponentLocation.appendConnectionPart(typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (this.isBatchAggregator(componentModel) ? parentComponentLocation.appendLocationPart(BATCH_AGGREGATOR_COMPONENT_IDENTIFIER.getName(), Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.UNKNOWN).identifier(BATCH_AGGREGATOR_COMPONENT_IDENTIFIER).build()), componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn())))))))));
        } else {
            ComponentAst parentComponentModel = hierarchy.get(hierarchy.size() - 1);
            DefaultComponentLocation parentComponentLocation = (DefaultComponentLocation)parentComponentModel.getLocation();
            componentLocation = parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
        }
        ((ComponentModel)componentModel).setComponentLocation(componentLocation);
    }

    private boolean isConnection(ComponentAst componentModel) {
        return componentModel.getModel(ConnectionProviderModel.class).isPresent();
    }

    private boolean isBatchAggregator(ComponentAst componentModel) {
        return BATCH_AGGREGATOR_COMPONENT_IDENTIFIER.equals(componentModel.getIdentifier());
    }

    private boolean isRoute(ComponentAst componentModel) {
        return componentModel.getIdentifier().equals(ROUTE_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(CHOICE_WHEN_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(CHOICE_OTHERWISE_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(BATCH_PROCESSS_RECORDS_COMPONENT_IDENTIFIER) || componentModel.getIdentifier().equals(BATCH_ON_COMPLETE_IDENTIFIER) || componentModel.getIdentifier().equals(BATCH_STEP_COMPONENT_IDENTIFIER) || componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ROUTE);
    }

    private boolean isHttpProxyPart(ComponentAst componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.HTTP_PROXY_SOURCE_POLICY_IDENTIFIER) || componentModel.getIdentifier().equals(ApplicationModel.HTTP_PROXY_OPERATION_IDENTIFIER);
    }

    private boolean isMunitFlowIdentifier(ComponentAst componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.MUNIT_TEST_IDENTIFIER);
    }

    private boolean isRootProcessorScope(ComponentAst componentModel) {
        ComponentIdentifier identifier = componentModel.getIdentifier();
        return identifier.equals(CoreDslConstants.FLOW_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_BEFORE_SUITE_IDENTIFIER) || identifier.equals(CoreDslConstants.SUBFLOW_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_BEFORE_TEST_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_AFTER_SUITE_IDENTIFIER) || identifier.equals(ApplicationModel.MUNIT_AFTER_TEST_IDENTIFIER);
    }

    private boolean isModuleOperation(ComponentAst componentModel) {
        return componentModel.getModel(OperationModel.class).isPresent();
    }

    private boolean parentComponentIsRouter(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        return this.existsWithinRouter(componentModel, hierarchy) && ComponentModelHelper.isRouter(hierarchy.get(hierarchy.size() - 1));
    }

    private boolean existsWithinRouter(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        return hierarchy.stream().anyMatch(c -> ComponentModelHelper.isRouter(c));
    }

    private String findNonProcessorPath(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        return String.valueOf(Math.max(0, hierarchy.get(hierarchy.size() - 1).directChildrenStream().filter(c -> !c.getIdentifier().equals(ApplicationModel.REDELIVERY_POLICY_IDENTIFIER)).collect(Collectors.toList()).indexOf(componentModel)));
    }

    private String findRoutePath(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        return String.valueOf(hierarchy.get(hierarchy.size() - 1).directChildrenStream().filter(this::isRoute).collect(Collectors.toList()).indexOf(componentModel));
    }

    private DefaultComponentLocation processOnErrorModel(ComponentAst componentModel, List<ComponentAst> hierarchy, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        int position = hierarchy.get(hierarchy.size() - 1).directChildrenStream().collect(Collectors.toList()).indexOf(componentModel);
        return parentComponentLocation.appendLocationPart(String.valueOf(position), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private DefaultComponentLocation processFlowDirectChild(ComponentAst componentModel, List<ComponentAst> hierarchy, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        DefaultComponentLocation componentLocation = ComponentModelHelper.isMessageSource(componentModel) ? parentComponentLocation.appendLocationPart(SOURCE_PART_NAME, typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (ComponentModelHelper.isProcessor(componentModel) ? parentComponentLocation.appendLocationPart(PROCESSORS_PART_NAME, Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart(this.findProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()) : (ComponentModelHelper.isErrorHandler(componentModel) ? this.processErrorHandlerComponent(componentModel, parentComponentLocation, typedComponentIdentifier) : parentComponentLocation.appendLocationPart(this.findNonProcessorPath(componentModel, hierarchy), typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn())));
        return componentLocation;
    }

    private Optional<TypedComponentIdentifier> getModuleOperationTypeComponentIdentifier(ComponentAst componentModel) {
        ComponentIdentifier originalIdentifier = componentModel.getIdentifier();
        String namespace = originalIdentifier.getNamespace();
        String operationName = originalIdentifier.getName();
        ComponentIdentifier operationIdentifier = ComponentIdentifier.builder().namespace(namespace).name(operationName).build();
        return Optional.of(TypedComponentIdentifier.builder().identifier(operationIdentifier).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    }

    private DefaultComponentLocation processModuleOperationChildren(ComponentAst componentModel, List<ComponentAst> hierarchy, Optional<TypedComponentIdentifier> operationTypedIdentifier) {
        Optional<TypedComponentIdentifier> parentOperationTypedIdentifier = this.getModuleOperationTypeComponentIdentifier(hierarchy.get(hierarchy.size() - 1));
        String operationName = parentOperationTypedIdentifier.get().getIdentifier().getName();
        return new DefaultComponentLocation(Optional.of(operationName), Collections.emptyList()).appendLocationPart(operationName, parentOperationTypedIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn()).appendLocationPart(PROCESSORS_PART_NAME, Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart(this.findProcessorPath(componentModel, hierarchy), operationTypedIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private DefaultComponentLocation processErrorHandlerComponent(ComponentAst componentModel, DefaultComponentLocation parentComponentLocation, Optional<TypedComponentIdentifier> typedComponentIdentifier) {
        return parentComponentLocation.appendLocationPart("errorHandler", typedComponentIdentifier, componentModel.getMetadata().getFileName(), componentModel.getMetadata().getStartLine(), componentModel.getMetadata().getStartColumn());
    }

    private String findProcessorPath(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        return String.valueOf(hierarchy.get(hierarchy.size() - 1).directChildrenStream().filter(ComponentModelHelper::isProcessor).collect(Collectors.toList()).indexOf(componentModel));
    }

    private boolean existsWithinRootContainer(ComponentAst componentModel, List<ComponentAst> hierarchy) {
        return this.existsWithin(hierarchy, CoreDslConstants.FLOW_IDENTIFIER) || this.existsWithin(hierarchy, ApplicationModel.MUNIT_TEST_IDENTIFIER) || this.existsWithin(hierarchy, ApplicationModel.MUNIT_BEFORE_SUITE_IDENTIFIER) || this.existsWithin(hierarchy, ApplicationModel.MUNIT_BEFORE_TEST_IDENTIFIER) || this.existsWithin(hierarchy, ApplicationModel.MUNIT_AFTER_SUITE_IDENTIFIER) || this.existsWithin(hierarchy, ApplicationModel.MUNIT_AFTER_TEST_IDENTIFIER) || this.existsWithin(hierarchy, ApplicationModel.HTTP_PROXY_POLICY_IDENTIFIER) || this.existsWithinConfig(hierarchy) || this.existsWithinRootErrorHandler(componentModel, hierarchy) || this.existsWithinSubflow(hierarchy);
    }

    private boolean existsWithinConfig(List<ComponentAst> hierarchy) {
        return hierarchy.stream().anyMatch(p -> p.getModel(ConfigurationModel.class).isPresent());
    }

    private boolean existsWithinRootErrorHandler(ComponentAst componentAst, List<ComponentAst> hierarchy) {
        return !hierarchy.isEmpty() && hierarchy.get(0).getIdentifier().equals(CoreDslConstants.ERROR_HANDLER_IDENTIFIER);
    }

    private boolean existsWithinSubflow(List<ComponentAst> hierarchy) {
        return this.existsWithin(hierarchy, CoreDslConstants.SUBFLOW_IDENTIFIER);
    }

    private boolean existsWithin(List<ComponentAst> hierarchy, ComponentIdentifier componentIdentifier) {
        return hierarchy.stream().anyMatch(componentModel -> componentModel.getIdentifier().equals(componentIdentifier));
    }
}

