/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;

class ComponentModelReaderHelper {
    static final String PASSWORD_MASK = "@@credentials@@";

    private ComponentModelReaderHelper() {
    }

    static String toXml(ComponentModel rootComponentModel) {
        return ComponentModelReaderHelper.toXml(rootComponentModel, 0);
    }

    private static String toXml(ComponentModel cm, int tab) {
        String spaces = StringUtils.repeat((String)" ", (int)(tab * 3));
        StringBuilder sb = new StringBuilder(spaces).append("<").append(cm.getIdentifier().toString());
        cm.getRawParameters().forEach((id, value) -> sb.append(" ").append((String)id).append("=\"").append((String)value).append("\""));
        if (cm.getInnerComponents().isEmpty() && StringUtils.isBlank((CharSequence)cm.getTextContent())) {
            sb.append("/>");
        } else {
            sb.append(">");
            cm.getInnerComponents().forEach(componentModel -> sb.append(System.lineSeparator()).append(ComponentModelReaderHelper.toXml(componentModel, tab + 1)));
            if (StringUtils.isNotBlank((CharSequence)cm.getTextContent())) {
                sb.append("<![CDATA[").append(spaces).append(cm.getTextContent()).append("]]>");
            }
            sb.append(System.lineSeparator()).append(spaces).append("</").append(cm.getIdentifier().toString()).append(">");
        }
        return LocationExecutionContextProvider.maskPasswords((String)sb.toString(), (String)PASSWORD_MASK);
    }
}

