/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.ComponentModelInitializer;
import org.mule.runtime.config.internal.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.LazyConnectivityTestingService;
import org.mule.runtime.config.internal.LazyMetadataService;
import org.mule.runtime.config.internal.LazyValueProviderService;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.TrackingPostProcessor;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.config.internal.parsers.generic.AutoIdUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureFlaggingService;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.metadata.cache.DefaultPersistentMetadataCacheManager;
import org.mule.runtime.core.internal.metadata.cache.DelegateMetadataCacheManager;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.store.SharedPartitionedPersistentObjectStore;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializerAdapter,
ComponentModelInitializer {
    public static final String SHARED_PARTITIONED_PERSISTENT_OBJECT_STORE_PATH = "_sharedPartitionatedPersistentObjectStorePath";
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyMuleArtifactContext.class);
    private static final String DEFAULT_METADATA_CACHE_MANAGER_KEY = "_defaultPersistentMetadataCacheManager";
    private static final String LAZY_MULE_OBJECT_STORE_MANAGER = "_muleLazyObjectStoreManager";
    private TrackingPostProcessor trackingPostProcessor;
    private final Optional<ComponentModelInitializer> parentComponentModelInitializer;
    private final ArtifactAstDependencyGraph graph;
    private final Set<String> currentComponentLocationsRequested = new HashSet<String>();
    private boolean appliedStartedPhaseRequest = false;

    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ComponentModelInitializer> parentComponentModelInitializer, Optional<ConfigurationProperties> parentConfigurationProperties, boolean disableXmlValidations, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider, LockFactory runtimeLockFactory, FeatureFlaggingService featureFlaggingService) throws BeansException {
        super(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, LazyMuleArtifactContext.extendArtifactProperties(artifactProperties), artifactType, pluginsClassLoaders, parentConfigurationProperties, disableXmlValidations, runtimeComponentBuildingDefinitionProvider, featureFlaggingService);
        this.componentLocator = new SpringConfigurationComponentLocator();
        this.parentComponentModelInitializer = parentComponentModelInitializer;
        CustomizationService customizationService = muleContext.getCustomizationService();
        customizationService.overrideDefaultServiceImpl("_muleConnectivityTestingService", (Object)new LazyConnectivityTestingService(this, () -> (ConnectivityTestingService)this.getRegistry().lookupByName("_muleNonLazyConnectivityTestingService").get()));
        customizationService.registerCustomServiceClass("_muleNonLazyConnectivityTestingService", DefaultConnectivityTestingService.class);
        customizationService.overrideDefaultServiceImpl("_muleMetadataService", (Object)new LazyMetadataService(this, () -> (MetadataService)this.getRegistry().lookupByName("_muleNonLazyMetadataService").get()));
        customizationService.registerCustomServiceClass("_muleNonLazyMetadataService", MuleMetadataService.class);
        customizationService.overrideDefaultServiceImpl("_muleValueProviderService", (Object)new LazyValueProviderService(this, () -> (ValueProviderService)this.getRegistry().lookupByName("_muleNonLazyValueProviderService").get(), () -> ((MuleContext)muleContext).getConfigurationComponentLocator()));
        customizationService.registerCustomServiceClass("_muleNonLazyValueProviderService", MuleValueProviderService.class);
        customizationService.overrideDefaultServiceImpl("_muleLazyComponentInitializer", (Object)this);
        String sharedPartitionatedPersistentObjectStorePath = artifactProperties.get(SHARED_PARTITIONED_PERSISTENT_OBJECT_STORE_PATH);
        if (sharedPartitionatedPersistentObjectStorePath != null) {
            muleContext.getCustomizationService().registerCustomServiceClass("_defaultSharedPersistentObjectStore", SharedPartitionedPersistentObjectStore.class);
            muleContext.getCustomizationService().overrideDefaultServiceImpl("_defaultSharedPersistentObjectStore", (Object)new SharedPartitionedPersistentObjectStore(new File(sharedPartitionatedPersistentObjectStorePath), runtimeLockFactory));
            MuleObjectStoreManager osm = new MuleObjectStoreManager();
            osm.setBasePersistentStoreKey("_defaultSharedPersistentObjectStore");
            osm.setBaseTransientStoreKey("_defaultInMemoryObjectStore");
            try {
                this.getMuleRegistry().registerObject(LAZY_MULE_OBJECT_STORE_MANAGER, (Object)osm);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            muleContext.getCustomizationService().registerCustomServiceClass(DEFAULT_METADATA_CACHE_MANAGER_KEY, DefaultPersistentMetadataCacheManager.class);
            muleContext.getCustomizationService().overrideDefaultServiceImpl("_metadataCacheManager", (Object)new DelegateMetadataCacheManager(() -> {
                DefaultPersistentMetadataCacheManager defaultPersistentMetadataCacheManager = (DefaultPersistentMetadataCacheManager)this.getRegistry().lookupByName(DEFAULT_METADATA_CACHE_MANAGER_KEY).get();
                defaultPersistentMetadataCacheManager.setLockFactory(runtimeLockFactory);
                defaultPersistentMetadataCacheManager.setObjectStoreManager((ObjectStoreManager)this.getRegistry().lookupByName(LAZY_MULE_OBJECT_STORE_MANAGER).get());
                return defaultPersistentMetadataCacheManager;
            }));
        }
        this.initialize();
        this.graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)this.applicationModel);
    }

    @Override
    protected boolean isRuntimeMode() {
        return false;
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.trackingPostProcessor = new TrackingPostProcessor();
        this.addBeanPostProcessors(beanFactory, this.trackingPostProcessor);
    }

    private static Map<String, String> extendArtifactProperties(Map<String, String> artifactProperties) {
        HashMap<String, String> extendedArtifactProperties = new HashMap<String, String>(artifactProperties);
        extendedArtifactProperties.put("mule.application.deployment.lazyInit", "true");
        return extendedArtifactProperties;
    }

    private void applyLifecycle(List<Object> components, boolean applyStartPhase) {
        this.getMuleContext().withLifecycleLock(() -> {
            if (this.getMuleContext().isInitialised()) {
                this.initializeComponents(components);
            }
            if (this.getMuleContext().isStarted()) {
                if (applyStartPhase) {
                    this.startComponent(components);
                } else {
                    this.startConfigurationProviders(components);
                }
            }
        });
    }

    private void startConfigurationProviders(List<Object> components) {
        components.stream().filter(component -> component instanceof ConfigurationProvider).forEach(configurationProviders -> {
            try {
                this.getMuleRegistry().applyLifecycle(configurationProviders, "initialise", "start");
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    private void initializeComponents(List<Object> components) {
        for (Object object : components) {
            LOGGER.debug("Initializing component '{}'...", (Object)object.toString());
            try {
                if (object instanceof MessageProcessorChain) continue;
                this.getMuleRegistry().applyLifecycle(object, "initialise");
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private void startComponent(List<Object> components) {
        for (Object object : components) {
            LOGGER.debug("Starting component '{}'...", (Object)object.toString());
            try {
                if (object instanceof MessageProcessorChain) continue;
                this.getMuleRegistry().applyLifecycle(object, "initialise", "start");
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void initializeComponent(Location location) {
        this.initializeComponent(location, true);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter) {
        this.initializeComponents(filter, true);
    }

    @Override
    public void initializeComponent(Location location, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.empty(), Optional.of(location), applyStartPhase, this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.of(o -> {
            ComponentModel componentModel = (ComponentModel)o;
            if (componentModel.getComponentLocation() != null) {
                return filter.accept((ComponentLocation)componentModel.getComponentLocation());
            }
            return false;
        }), Optional.empty(), applyStartPhase, this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    @Override
    public void initializeComponents(Predicate<ComponentAst> componentModelPredicate, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.of(componentModelPredicate), Optional.empty(), applyStartPhase, this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    public Optional<ComponentModelInitializerAdapter> getParentComponentModelInitializerAdapter(boolean applyStartPhase) {
        return this.parentComponentModelInitializer.map(componentModelInitializer -> componentModelPredicate -> componentModelInitializer.initializeComponents(componentModelPredicate, applyStartPhase));
    }

    private List<Object> createComponents(Optional<Predicate<ComponentAst>> predicateOptional, Optional<Location> locationOptional, boolean applyStartPhase, Optional<ComponentModelInitializerAdapter> parentComponentModelInitializerAdapter) {
        Preconditions.checkState((predicateOptional.isPresent() != locationOptional.isPresent() ? 1 : 0) != 0, (String)"predicate or location has to be passed");
        return (List)ClassUtils.withContextClassLoader((ClassLoader)this.getMuleContext().getExecutionClassLoader(), () -> {
            Predicate basePredicate = predicateOptional.orElseGet(() -> comp -> comp.getLocation() != null && comp.getLocation().getLocation().equals(((Location)locationOptional.get()).toString()));
            ArtifactAst minimalApplicationModel = this.buildMinimalApplicationModel(basePredicate);
            if (locationOptional.map(loc -> minimalApplicationModel.recursiveStream().noneMatch(comp -> comp.getLocation() != null && comp.getLocation().getLocation().equals(loc.toString()))).orElse(false).booleanValue()) {
                throw new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage((String)("No object found at location " + ((Location)locationOptional.get()).toString())));
            }
            Set requestedLocations = locationOptional.map(location -> Sets.newHashSet((Object[])new String[]{location.toString()})).orElseGet(() -> this.applicationModel.recursiveStream().filter(basePredicate).filter(comp -> comp.getLocation() != null).map(comp -> comp.getLocation().getLocation()).collect(Collectors.toSet()));
            if (ImmutableSet.copyOf(this.currentComponentLocationsRequested).equals((Object)ImmutableSet.copyOf((Collection)requestedLocations)) && this.appliedStartedPhaseRequest == applyStartPhase) {
                return Collections.emptyList();
            }
            if (parentComponentModelInitializerAdapter.isPresent()) {
                ((ComponentModelInitializerAdapter)parentComponentModelInitializerAdapter.get()).initializeComponents((ComponentAst componentModel) -> this.graph.getMissingDependencies().stream().anyMatch(missingDep -> missingDep.isSatisfiedBy(componentModel)));
            } else {
                this.graph.getMissingDependencies().stream().forEach(missingDep -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Ignoring dependency {} because it does not exist.", missingDep);
                    }
                });
            }
            this.unregisterBeans(this.trackingPostProcessor.getBeansTracked());
            this.currentComponentLocationsRequested.clear();
            this.currentComponentLocationsRequested.addAll(requestedLocations);
            this.appliedStartedPhaseRequest = applyStartPhase;
            this.trackingPostProcessor.reset();
            this.objectProviders.clear();
            this.resetMuleSecurityManager();
            List<Pair<String, ComponentAst>> applicationComponents = this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalApplicationModel, false);
            super.prepareObjectProviders();
            return this.createBeans(applicationComponents);
        });
    }

    private ArtifactAst buildMinimalApplicationModel(Predicate<ComponentAst> basePredicate) {
        Predicate<ComponentAst> txManagerPredicate = componentModel -> {
            ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor((ComponentModel)componentModel);
            return this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).map(componentBuildingDefinition -> {
                componentBuildingDefinition.getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
                return TransactionManagerFactory.class.isAssignableFrom(objectTypeVisitor.getType());
            }).orElse(false);
        };
        Predicate<ComponentAst> alwaysEnabledPredicate = componentModel -> this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).map(ComponentBuildingDefinition::isAlwaysEnabled).orElse(false);
        Predicate<ComponentAst> languageConstructPredicate = componentModel -> this.beanDefinitionFactory.isLanguageConstructComponent(componentModel.getIdentifier());
        final ArtifactAst predicatedModel = this.graph.minimalArtifactFor(basePredicate.or(txManagerPredicate).or(alwaysEnabledPredicate).or(languageConstructPredicate));
        final Set allNamespaces = predicatedModel.recursiveStream().map(comp -> comp.getIdentifier().getNamespaceUri()).collect(Collectors.toSet());
        return new ArtifactAst(){

            public Stream<ComponentAst> topLevelComponentsStream() {
                return Stream.concat(this.getDefaultGlobalElements(), predicatedModel.topLevelComponentsStream());
            }

            public Spliterator<ComponentAst> topLevelComponentsSpliterator() {
                return Stream.concat(this.getDefaultGlobalElements(), predicatedModel.topLevelComponentsStream()).spliterator();
            }

            public Stream<ComponentAst> recursiveStream() {
                return Stream.concat(this.getDefaultGlobalElements().flatMap(comp -> comp.recursiveStream()), predicatedModel.recursiveStream());
            }

            public Spliterator<ComponentAst> recursiveSpliterator() {
                return Stream.concat(this.getDefaultGlobalElements().flatMap(comp -> comp.recursiveStream()), predicatedModel.recursiveStream()).spliterator();
            }

            private Stream<ComponentAst> getDefaultGlobalElements() {
                return LazyMuleArtifactContext.this.applicationModel.topLevelComponentsStream().filter(comp -> "_defaultGlobalElements".equals(comp.getIdentifier().getName()) && allNamespaces.contains(comp.getIdentifier().getNamespaceUri())).flatMap(comp -> comp.directChildrenStream());
            }
        };
    }

    @Override
    protected List<Pair<String, ComponentAst>> createApplicationComponents(DefaultListableBeanFactory beanFactory, ArtifactAst minimalAppModel, boolean mustBeRoot) {
        List<Pair<String, ComponentAst>> applicationComponents = super.createApplicationComponents(beanFactory, minimalAppModel, mustBeRoot);
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)minimalAppModel);
        LOGGER.debug("orphanComponents found: {}", (Object)orphanComponents.toString());
        orphanComponents.stream().filter(cm -> Arrays.asList(TypedComponentIdentifier.ComponentType.SOURCE, TypedComponentIdentifier.ComponentType.OPERATION, TypedComponentIdentifier.ComponentType.SCOPE).contains(cm.getComponentType())).filter(cm -> cm.getComponentId().isPresent()).forEach(cm -> {
            String nameAttribute = (String)cm.getComponentId().get();
            LOGGER.debug("Registering orphan named component '{}'...", (Object)nameAttribute);
            applicationComponents.add(0, new Pair((Object)nameAttribute, cm));
            BeanDefinition beanDef = ((SpringComponentModel)cm).getBeanDefinition();
            if (beanDef != null) {
                beanFactory.registerBeanDefinition((String)cm.getComponentId().get(), beanDef);
                LazyMuleArtifactContext.postProcessBeanDefinition((SpringComponentModel)cm, (BeanDefinitionRegistry)beanFactory, (String)cm.getComponentId().get());
            }
        });
        orphanComponents.stream().forEach(cm -> {
            BeanDefinition beanDef = ((SpringComponentModel)cm).getBeanDefinition();
            if (beanDef != null) {
                String beanName = cm.getComponentId().orElse(AutoIdUtils.uniqueValue(beanDef.getBeanClassName()));
                LOGGER.debug("Registering orphan un-named component '{}'...", (Object)beanName);
                applicationComponents.add(new Pair((Object)beanName, cm));
                beanFactory.registerBeanDefinition(beanName, beanDef);
                LazyMuleArtifactContext.postProcessBeanDefinition((SpringComponentModel)cm, (BeanDefinitionRegistry)beanFactory, beanName);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("applicationComponents to be created: {}", (Object)applicationComponents.toString());
        }
        return applicationComponents;
    }

    private List<Object> createBeans(List<Pair<String, ComponentAst>> applicationComponentNames) {
        this.trackingPostProcessor.startTracking();
        LinkedHashMap objects = new LinkedHashMap();
        applicationComponentNames.forEach(componentPair -> {
            try {
                Object object = this.getRegistry().lookupByName((String)componentPair.getFirst()).orElse(null);
                if (object != null) {
                    if (object instanceof MessageProcessorChainBuilder) {
                        this.handleChainBuilder((MessageProcessorChainBuilder)object, (Pair<String, ComponentAst>)componentPair, objects);
                    } else if (object instanceof TransactionManagerFactory) {
                        this.handleTxManagerFactory((TransactionManagerFactory)object);
                    }
                    objects.put(componentPair, object);
                }
            }
            catch (Exception e) {
                this.trackingPostProcessor.stopTracking();
                this.trackingPostProcessor.intersection(objects.keySet().stream().map(pair -> (String)pair.getFirst()).collect(Collectors.toList()));
                this.safeUnregisterBean((String)componentPair.getFirst());
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        HashMap componentNames = new HashMap();
        objects.entrySet().forEach(entry -> {
            Object object = entry.getValue();
            Pair component = (Pair)entry.getKey();
            componentNames.put(object, component);
        });
        this.trackingPostProcessor.stopTracking();
        this.trackingPostProcessor.intersection(objects.keySet().stream().map(pair -> (String)pair.getFirst()).collect(Collectors.toList()));
        ArrayList<Object> sortedObjects = new ArrayList<Object>(objects.values());
        Collections.sort(sortedObjects, (o1, o2) -> this.graph.dependencyComparator().compare(((Pair)componentNames.get(o1)).getSecond(), ((Pair)componentNames.get(o2)).getSecond()));
        return sortedObjects;
    }

    private void handleChainBuilder(MessageProcessorChainBuilder object, Pair<String, ComponentAst> componentPair, Map<Pair<String, ComponentAst>, Object> objects) {
        Pair chainKey = new Pair((Object)((String)componentPair.getFirst() + "@" + object.hashCode()), componentPair.getSecond());
        MessageProcessorChain messageProcessorChain = object.build();
        try {
            LifecycleUtils.initialiseIfNeeded((Object)messageProcessorChain, (MuleContext)this.getMuleContext());
        }
        catch (InitialisationException e) {
            this.unregisterBeans(objects.keySet().stream().map(p -> (String)p.getFirst()).collect(Collectors.toList()));
            throw new IllegalStateException("Couldn't initialise an instance of a MessageProcessorChain", e);
        }
        try {
            this.getMuleRegistry().registerObject((String)chainKey.getFirst(), (Object)messageProcessorChain);
        }
        catch (RegistrationException e) {
            this.unregisterBeans(objects.keySet().stream().map(p -> (String)p.getFirst()).collect(Collectors.toList()));
            throw new IllegalStateException("Couldn't register an instance of a MessageProcessorChain", e);
        }
        objects.put((Pair<String, ComponentAst>)chainKey, messageProcessorChain);
    }

    private void handleTxManagerFactory(TransactionManagerFactory object) {
        try {
            this.getMuleContext().setTransactionManager(object.create(this.getMuleContext().getConfiguration()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't register an instance of a TransactionManager", e);
        }
    }

    private void resetMuleSecurityManager() {
        boolean registerMuleSecurityManager;
        block5: {
            registerMuleSecurityManager = false;
            try {
                this.getMuleRegistry().unregisterObject("_muleSecurityManager");
                registerMuleSecurityManager = true;
            }
            catch (Exception e) {
                if (ExceptionUtils.hasCause((Throwable)e, NoSuchBeanDefinitionException.class)) break block5;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while unregistering Mule security manager"), (Throwable)e);
            }
        }
        if (registerMuleSecurityManager) {
            try {
                this.getMuleRegistry().registerObject("_muleSecurityManager", (Object)new DefaultMuleSecurityManager());
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Couldn't register a new instance of Mule security manager in the registry"), (Throwable)e);
            }
        }
    }

    @Override
    protected void prepareObjectProviders() {
    }

    @Override
    public void close() {
        if (this.trackingPostProcessor != null) {
            this.trackingPostProcessor.stopTracking();
            this.trackingPostProcessor.reset();
        }
        this.appliedStartedPhaseRequest = false;
        this.currentComponentLocationsRequested.clear();
        super.close();
    }

    private void unregisterBeans(List<String> beans) {
        this.doUnregisterBeans(beans.stream().collect(Collectors.toCollection(LinkedList::new)).descendingIterator());
        this.componentLocator.removeComponents();
    }

    private void doUnregisterBeans(Iterator<String> beanNames) {
        while (beanNames.hasNext()) {
            String beanName = beanNames.next();
            try {
                LegacyRegistryUtils.unregisterObject((MuleContext)this.getMuleContext(), (String)beanName);
            }
            catch (Exception e) {
                this.logger.error((Object)String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", beanName, e.getMessage()));
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"There was an error while unregistering component '%s'", (Object[])new Object[]{beanName}), (Throwable)e);
            }
        }
    }

    private void safeUnregisterBean(String beanName) {
        try {
            LegacyRegistryUtils.unregisterObject((MuleContext)this.getMuleContext(), (String)beanName);
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    @Override
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.applicationModel.recursiveStream().filter(cm -> !this.beanDefinitionFactory.isComponentIgnored(cm.getIdentifier())).forEach(cm -> this.componentLocator.addComponentLocation(cm.getLocation()));
    }

    @FunctionalInterface
    private static interface ComponentModelInitializerAdapter {
        public void initializeComponents(Predicate<ComponentAst> var1);
    }
}

