/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.config.internal.BeanWrapper;
import org.mule.runtime.config.internal.SpringRegistry;
import org.mule.runtime.core.internal.lifecycle.InjectedDependenciesProvider;

public class DeclaredDependencyResolver {
    private final SpringRegistry springRegistry;

    public DeclaredDependencyResolver(SpringRegistry springRegistry) {
        this.springRegistry = springRegistry;
    }

    public List<BeanWrapper> getDeclaredDependencies(Object object) {
        List<BeanWrapper> dependencies = new ArrayList<BeanWrapper>();
        if (!(object instanceof InjectedDependenciesProvider)) {
            return dependencies;
        }
        dependencies = ((InjectedDependenciesProvider)object).getInjectedDependencies().stream().map(dependency -> (List)dependency.reduce(this::beansOfTypeList, this::beansOfNameList)).flatMap(Collection::stream).collect(Collectors.toList());
        return dependencies;
    }

    private List<BeanWrapper> beansOfNameList(String beanName) {
        return Collections.singletonList(new BeanWrapper(beanName, this.springRegistry.get(beanName)));
    }

    private List<BeanWrapper> beansOfTypeList(Class<?> type) {
        return Stream.of(this.springRegistry.getApplicationContext().getBeanNamesForType(type)).map(beanName -> new BeanWrapper((String)beanName, this.springRegistry.get((String)beanName))).collect(Collectors.toList());
    }
}

