/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.model.config.RuntimeConfigurationException;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

class ObjectBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String REF_PARAMETER = "ref";
    private static final String CLASS_PARAMETER = "class";

    ObjectBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (!componentModel.getIdentifier().equals(ComponentIdentifier.buildFromStringRepresentation((String)"mule:object"))) {
            return false;
        }
        String refParameterValue = componentModel.getRawParameters().get(REF_PARAMETER);
        String classParameterValue = componentModel.getRawParameters().get(CLASS_PARAMETER);
        if (refParameterValue != null && classParameterValue != null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Object cannot contain both '%s' and '%s' parameters. Offending resource is '%s'", REF_PARAMETER, CLASS_PARAMETER, componentModel.getComponentLocation())));
        }
        if (refParameterValue == null && classParameterValue == null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Object must contain '%s' or '%s' parameter. Offending resource is '%s'", REF_PARAMETER, CLASS_PARAMETER, componentModel.getComponentLocation())));
        }
        if (refParameterValue != null) {
            componentModel.setBeanReference((BeanReference)new RuntimeBeanReference(refParameterValue));
        }
        if (classParameterValue != null) {
            Class classParameter;
            try {
                classParameter = ClassUtils.loadClass((String)classParameterValue, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), e);
            }
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)AnnotatedObjectInvocationHandler.addAnnotationsToClass((Class)classParameter));
            CommonBeanDefinitionCreator.processMuleProperties(componentModel, beanDefinitionBuilder, null);
            componentModel.setBeanDefinition((BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return true;
    }
}

