/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.api.dsl.ConfigurableInstanceFactory;
import org.mule.runtime.config.api.dsl.ConfigurableObjectFactory;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionProviderUtils;
import org.mule.runtime.config.internal.CustomEncryptionStrategyDelegate;
import org.mule.runtime.config.internal.CustomSecurityProviderDelegate;
import org.mule.runtime.config.internal.MuleConfigurationConfigurator;
import org.mule.runtime.config.internal.NotificationConfig;
import org.mule.runtime.config.internal.ServerNotificationManagerConfigurator;
import org.mule.runtime.config.internal.dsl.processor.CustomSecurityFilterObjectFactory;
import org.mule.runtime.config.internal.dsl.processor.EnvironmentPropertyObjectFactory;
import org.mule.runtime.config.internal.dsl.processor.ReconnectionConfigObjectFactory;
import org.mule.runtime.config.internal.dsl.processor.RetryPolicyTemplateObjectFactory;
import org.mule.runtime.config.internal.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.runtime.config.internal.factories.ChoiceRouterObjectFactory;
import org.mule.runtime.config.internal.factories.DefaultFlowFactoryBean;
import org.mule.runtime.config.internal.factories.DynamicConfigExpirationObjectFactory;
import org.mule.runtime.config.internal.factories.ErrorHandlerFactoryBean;
import org.mule.runtime.config.internal.factories.ExpirationPolicyObjectFactory;
import org.mule.runtime.config.internal.factories.FlowRefFactoryBean;
import org.mule.runtime.config.internal.factories.OnErrorFactoryBean;
import org.mule.runtime.config.internal.factories.ProcessorExpressionRouteFactoryBean;
import org.mule.runtime.config.internal.factories.ProcessorRouteFactoryBean;
import org.mule.runtime.config.internal.factories.SchedulingMessageSourceFactoryBean;
import org.mule.runtime.config.internal.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.runtime.config.internal.factories.TryProcessorFactoryBean;
import org.mule.runtime.config.internal.factories.streaming.InMemoryCursorIteratorProviderObjectFactory;
import org.mule.runtime.config.internal.factories.streaming.InMemoryCursorStreamProviderObjectFactory;
import org.mule.runtime.config.internal.factories.streaming.NullCursorIteratorProviderObjectFactory;
import org.mule.runtime.config.internal.factories.streaming.NullCursorStreamProviderObjectFactory;
import org.mule.runtime.config.privileged.dsl.processor.AddVariablePropertyConfigurator;
import org.mule.runtime.config.privileged.dsl.processor.MessageProcessorChainFactoryBean;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.DynamicConfigExpiration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.RaiseErrorProcessor;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.security.MuleSecurityManagerConfigurator;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.api.source.scheduler.PeriodicScheduler;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.el.ExpressionLanguageComponent;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.el.mvel.configuration.AliasEntry;
import org.mule.runtime.core.internal.el.mvel.configuration.ImportEntry;
import org.mule.runtime.core.internal.el.mvel.configuration.MVELExpressionLanguageObjectFactory;
import org.mule.runtime.core.internal.el.mvel.configuration.MVELGlobalFunctionsConfig;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.OnErrorContinueHandler;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.internal.processor.InvokerMessageProcessor;
import org.mule.runtime.core.internal.processor.LoggerMessageProcessor;
import org.mule.runtime.core.internal.processor.TryScope;
import org.mule.runtime.core.internal.processor.simple.AddFlowVariableProcessor;
import org.mule.runtime.core.internal.processor.simple.ParseTemplateProcessor;
import org.mule.runtime.core.internal.processor.simple.RemoveFlowVariableProcessor;
import org.mule.runtime.core.internal.processor.simple.SetPayloadMessageProcessor;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.routing.ChoiceRouter;
import org.mule.runtime.core.internal.routing.FirstSuccessful;
import org.mule.runtime.core.internal.routing.Foreach;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.IdempotentMessageValidator;
import org.mule.runtime.core.internal.routing.ParallelForEach;
import org.mule.runtime.core.internal.routing.ProcessorExpressionRoute;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.routing.RoundRobin;
import org.mule.runtime.core.internal.routing.ScatterGatherRouter;
import org.mule.runtime.core.internal.routing.UntilSuccessful;
import org.mule.runtime.core.internal.routing.forkjoin.CollectListForkJoinStrategyFactory;
import org.mule.runtime.core.internal.security.PasswordBasedEncryptionStrategy;
import org.mule.runtime.core.internal.security.SecretKeyEncryptionStrategy;
import org.mule.runtime.core.internal.security.UsernamePasswordAuthenticationFilter;
import org.mule.runtime.core.internal.security.filter.MuleEncryptionEndpointSecurityFilter;
import org.mule.runtime.core.internal.source.scheduler.DefaultSchedulerMessageSource;
import org.mule.runtime.core.internal.transformer.encryption.AbstractEncryptionTransformer;
import org.mule.runtime.core.internal.transformer.simple.AutoTransformer;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.runtime.core.privileged.processor.IdempotentRedeliveryPolicy;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.objectfactory.MessageProcessorChainObjectFactory;
import org.mule.runtime.core.privileged.processor.simple.AbstractAddVariablePropertyProcessor;
import org.mule.runtime.core.privileged.transaction.xa.XaTransactionFactory;
import org.mule.runtime.core.privileged.transformer.simple.ByteArrayToObject;
import org.mule.runtime.core.privileged.transformer.simple.ByteArrayToSerializable;
import org.mule.runtime.core.privileged.transformer.simple.SerializableToByteArray;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.CommonTypeConverters;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class CoreComponentBuildingDefinitionProvider
implements ComponentBuildingDefinitionProvider {
    private static final String MESSAGE_PROCESSORS = "messageProcessors";
    private static final String NAME = "name";
    private static final String WHEN = "when";
    private static final String ERROR_HANDLER = "error-handler";
    private static final String ON_ERROR = "on-error";
    private static final String ON_ERROR_CONTINUE = "on-error-continue";
    private static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    private static final String SET_PAYLOAD = "set-payload";
    private static final String LOGGER = "logger";
    private static final String PROCESSOR_CHAIN = "processor-chain";
    private static final String ROUTE = "route";
    private static final String ROUTES = "routes";
    private static final String PROCESSOR = "processor";
    private static final String TRANSFORMER = "transformer";
    private static final String CUSTOM_PROCESSOR = "custom-processor";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String SUB_FLOW = "sub-flow";
    private static final String FLOW = "flow";
    private static final String FLOW_REF = "flow-ref";
    private static final String EXCEPTION_LISTENER_ATTRIBUTE = "exceptionListener";
    private static final String SCATTER_GATHER = "scatter-gather";
    private static final String PARALLEL_FOREACH = "parallel-foreach";
    private static final String FORK_JOIN_STRATEGY = "forkJoinStrategyFactory";
    private static final String COLLECT_LIST = "collect-list";
    private static final String ASYNC = "async";
    private static final String TRY = "try";
    private static final String UNTIL_SUCCESSFUL = "until-successful";
    private static final String FOREACH = "foreach";
    private static final String FIRST_SUCCESSFUL = "first-successful";
    private static final String ROUND_ROBIN = "round-robin";
    private static final String CHOICE = "choice";
    private static final String OTHERWISE = "otherwise";
    private static final String SCHEDULER = "scheduler";
    private static final String ERROR_TYPE = "errorType";
    private static final String TYPE = "type";
    private static final String TX_ACTION = "transactionalAction";
    private static final String TX_TYPE = "transactionType";
    private static final String LOG_EXCEPTION = "logException";
    private static final String RAISE_ERROR = "raise-error";
    private static final String INHERIT_ITERABLE_REPEATABILITY = "inheritIterableRepeatability";
    private static final Class<?> MESSAGE_PROCESSOR_CLASS = Processor.class;
    private static ComponentBuildingDefinition.Builder baseDefinition = new ComponentBuildingDefinition.Builder().withNamespace("mule");

    public void init() {
    }

    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<ComponentBuildingDefinition>();
        AttributeDefinition messageProcessorListAttributeDefinition = AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build();
        ComponentBuildingDefinition.Builder onErrorBaseBuilder = baseDefinition.withSetterParameterDefinition(MESSAGE_PROCESSORS, messageProcessorListAttributeDefinition).withSetterParameterDefinition(WHEN, AttributeDefinition.Builder.fromSimpleParameter((String)WHEN).build()).withSetterParameterDefinition(ERROR_TYPE, AttributeDefinition.Builder.fromSimpleParameter((String)TYPE).build()).withSetterParameterDefinition(LOG_EXCEPTION, AttributeDefinition.Builder.fromSimpleParameter((String)LOG_EXCEPTION).withDefaultValue((Object)"true").build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ON_ERROR).withTypeDefinition(TypeDefinition.fromType(TemplateOnErrorHandler.class)).withObjectFactoryType(OnErrorFactoryBean.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).build());
        componentBuildingDefinitions.add(onErrorBaseBuilder.withIdentifier(ON_ERROR_CONTINUE).withTypeDefinition(TypeDefinition.fromType(OnErrorContinueHandler.class)).asPrototype().build());
        componentBuildingDefinitions.add(onErrorBaseBuilder.withIdentifier(ON_ERROR_PROPAGATE).withTypeDefinition(TypeDefinition.fromType(OnErrorPropagateHandler.class)).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ERROR_HANDLER).withTypeDefinition(TypeDefinition.fromType(ErrorHandler.class)).withObjectFactoryType(ErrorHandlerFactoryBean.class).withSetterParameterDefinition("delegate", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("exceptionListeners", AttributeDefinition.Builder.fromChildCollectionConfiguration(FlowExceptionHandler.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SET_PAYLOAD).withTypeDefinition(TypeDefinition.fromType(SetPayloadMessageProcessor.class)).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).withSetterParameterDefinition("mimeType", AttributeDefinition.Builder.fromSimpleParameter((String)"mimeType").build()).withSetterParameterDefinition("encoding", AttributeDefinition.Builder.fromSimpleParameter((String)"encoding").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(LOGGER).withTypeDefinition(TypeDefinition.fromType(LoggerMessageProcessor.class)).withSetterParameterDefinition("message", AttributeDefinition.Builder.fromSimpleParameter((String)"message").build()).withSetterParameterDefinition("category", AttributeDefinition.Builder.fromSimpleParameter((String)"category").build()).withSetterParameterDefinition("level", AttributeDefinition.Builder.fromSimpleParameter((String)"level").build()).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getSetVariablePropertyBaseBuilder(this.getAddVariableTransformerInstanceFactory(AddFlowVariableProcessor.class), AddFlowVariableProcessor.class, KeyAttributeDefinitionPair.newBuilder().withKey("identifier").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"variableName").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("value").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).build()).withIdentifier("set-variable").withTypeDefinition(TypeDefinition.fromType(AddFlowVariableProcessor.class)).build());
        componentBuildingDefinitions.add(this.getCoreMuleMessageTransformerBaseBuilder().withIdentifier("remove-variable").withTypeDefinition(TypeDefinition.fromType(RemoveFlowVariableProcessor.class)).withSetterParameterDefinition("identifier", AttributeDefinition.Builder.fromSimpleParameter((String)"variableName").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("global-property").withTypeDefinition(TypeDefinition.fromType(String.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(TRANSFORMER).withTypeDefinition(TypeDefinition.fromType(Transformer.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(CUSTOM_PROCESSOR).withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE).checkingThatIsClassOrInheritsFrom(MESSAGE_PROCESSOR_CLASS)).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(PROCESSOR_CHAIN).withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(MessageProcessorChainObjectFactory.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ROUTE).withTypeDefinition(TypeDefinition.fromType(MessageProcessorChain.class)).withObjectFactoryType(MessageProcessorChainFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SUB_FLOW).withTypeDefinition(TypeDefinition.fromType(MessageProcessorChain.class)).withObjectFactoryType(SubflowMessageProcessorChainFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(FLOW).withTypeDefinition(TypeDefinition.fromType(Flow.class)).withObjectFactoryType(DefaultFlowFactoryBean.class).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("muleContext", AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("initialState", AttributeDefinition.Builder.fromSimpleParameter((String)"initialState").withDefaultValue((Object)"started").build()).withSetterParameterDefinition("messageSource", AttributeDefinition.Builder.fromChildConfiguration(MessageSource.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(EXCEPTION_LISTENER_ATTRIBUTE, AttributeDefinition.Builder.fromChildConfiguration(FlowExceptionHandler.class).build()).withSetterParameterDefinition("maxConcurrency", AttributeDefinition.Builder.fromSimpleParameter((String)"maxConcurrency").build()).build());
        ComponentBuildingDefinition.Builder processorRefBuilder = baseDefinition.withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(FlowRefFactoryBean.class);
        componentBuildingDefinitions.add(processorRefBuilder.withIdentifier(FLOW_REF).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter((String)"target").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter((String)"targetValue").withDefaultValue((Object)"#[payload]").build()).build());
        componentBuildingDefinitions.add(processorRefBuilder.withIdentifier(PROCESSOR).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)"ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(COLLECT_LIST).withTypeDefinition(TypeDefinition.fromType(CollectListForkJoinStrategyFactory.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SCATTER_GATHER).withTypeDefinition(TypeDefinition.fromType(ScatterGatherRouter.class)).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("maxConcurrency", AttributeDefinition.Builder.fromSimpleParameter((String)"maxConcurrency").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter((String)"target").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter((String)"targetValue").withDefaultValue((Object)"#[payload]").build()).withSetterParameterDefinition(ROUTES, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorChain.class).build()).withSetterParameterDefinition(FORK_JOIN_STRATEGY, AttributeDefinition.Builder.fromChildConfiguration(ForkJoinStrategyFactory.class).build()).asScope().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(PARALLEL_FOREACH).withTypeDefinition(TypeDefinition.fromType(ParallelForEach.class)).withSetterParameterDefinition("collectionExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"collection").build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("maxConcurrency", AttributeDefinition.Builder.fromSimpleParameter((String)"maxConcurrency").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter((String)"target").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter((String)"targetValue").withDefaultValue((Object)"#[payload]").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asScope().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("collection").withTypeDefinition(TypeDefinition.fromType(String.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ASYNC).withTypeDefinition(TypeDefinition.fromType(AsyncDelegateMessageProcessor.class)).withObjectFactoryType(AsyncMessageProcessorsFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("maxConcurrency", AttributeDefinition.Builder.fromSimpleParameter((String)"maxConcurrency").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(TRY).withTypeDefinition(TypeDefinition.fromType(TryScope.class)).withObjectFactoryType(TryProcessorFactoryBean.class).withSetterParameterDefinition(EXCEPTION_LISTENER_ATTRIBUTE, AttributeDefinition.Builder.fromChildConfiguration(FlowExceptionHandler.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(TX_ACTION, AttributeDefinition.Builder.fromSimpleParameter((String)TX_ACTION).withDefaultValue((Object)"INDIFFERENT").build()).withSetterParameterDefinition(TX_TYPE, AttributeDefinition.Builder.fromSimpleParameter((String)TX_TYPE, this.getTransactionTypeConverter()).withDefaultValue((Object)TransactionType.LOCAL.name()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(UNTIL_SUCCESSFUL).withTypeDefinition(TypeDefinition.fromType(UntilSuccessful.class)).withSetterParameterDefinition("maxRetries", AttributeDefinition.Builder.fromSimpleParameter((String)"maxRetries").withDefaultValue((Object)"5").build()).withSetterParameterDefinition("millisBetweenRetries", AttributeDefinition.Builder.fromSimpleParameter((String)"millisBetweenRetries").withDefaultValue((Object)"60000").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(FOREACH).withTypeDefinition(TypeDefinition.fromType(Foreach.class)).withSetterParameterDefinition("collectionExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"collection").build()).withSetterParameterDefinition("batchSize", AttributeDefinition.Builder.fromSimpleParameter((String)"batchSize").build()).withSetterParameterDefinition("rootMessageVariableName", AttributeDefinition.Builder.fromSimpleParameter((String)"rootMessageVariableName").build()).withSetterParameterDefinition("counterVariableName", AttributeDefinition.Builder.fromSimpleParameter((String)"counterVariableName").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(FIRST_SUCCESSFUL).withTypeDefinition(TypeDefinition.fromType(FirstSuccessful.class)).withSetterParameterDefinition(ROUTES, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorChain.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ROUND_ROBIN).withTypeDefinition(TypeDefinition.fromType(RoundRobin.class)).withSetterParameterDefinition(ROUTES, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorChain.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(CHOICE).withTypeDefinition(TypeDefinition.fromType(ChoiceRouter.class)).withObjectFactoryType(ChoiceRouterObjectFactory.class).withSetterParameterDefinition(ROUTES, AttributeDefinition.Builder.fromChildCollectionConfiguration(ProcessorExpressionRoute.class).build()).withSetterParameterDefinition("defaultRoute", AttributeDefinition.Builder.fromChildConfiguration(ProcessorRoute.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(WHEN).withTypeDefinition(TypeDefinition.fromType(ProcessorExpressionRoute.class)).withObjectFactoryType(ProcessorExpressionRouteFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter((String)"expression").withDefaultValue((Object)"true").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(OTHERWISE).withTypeDefinition(TypeDefinition.fromType(ProcessorRoute.class)).withObjectFactoryType(ProcessorRouteFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SCHEDULER).withTypeDefinition(TypeDefinition.fromType(DefaultSchedulerMessageSource.class)).withObjectFactoryType(SchedulingMessageSourceFactoryBean.class).withSetterParameterDefinition("disallowConcurrentExecution", AttributeDefinition.Builder.fromSimpleParameter((String)"disallowConcurrentExecution").withDefaultValue((Object)false).build()).withSetterParameterDefinition(SCHEDULER, AttributeDefinition.Builder.fromChildConfiguration(PeriodicScheduler.class).withWrapperIdentifier("scheduling-strategy").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("fixed-frequency").withTypeDefinition(TypeDefinition.fromType(FixedFrequencyScheduler.class)).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter((String)"frequency").withDefaultValue((Object)this.getDefaultSchedulerFixedFrequency()).build()).withSetterParameterDefinition("startDelay", AttributeDefinition.Builder.fromSimpleParameter((String)"startDelay").build()).withSetterParameterDefinition("timeUnit", AttributeDefinition.Builder.fromSimpleParameter((String)"timeUnit").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("cron").withTypeDefinition(TypeDefinition.fromType(CronScheduler.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).withSetterParameterDefinition("timeZone", AttributeDefinition.Builder.fromSimpleParameter((String)"timeZone").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("configuration").withTypeDefinition(TypeDefinition.fromType(MuleConfiguration.class)).withObjectFactoryType(MuleConfigurationConfigurator.class).withSetterParameterDefinition("defaultErrorHandlerName", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultErrorHandler-ref").build()).withSetterParameterDefinition("defaultResponseTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultResponseTimeout").build()).withSetterParameterDefinition("maxQueueTransactionFilesSize", AttributeDefinition.Builder.fromSimpleParameter((String)"maxQueueTransactionFilesSize").build()).withSetterParameterDefinition("defaultTransactionTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultTransactionTimeout").build()).withSetterParameterDefinition("shutdownTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"shutdownTimeout").build()).withSetterParameterDefinition("defaultObjectSerializer", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"defaultObjectSerializer-ref").build()).withSetterParameterDefinition("extensions", AttributeDefinition.Builder.fromChildCollectionConfiguration(ConfigurationExtension.class).build()).withSetterParameterDefinition("dynamicConfigExpiration", AttributeDefinition.Builder.fromChildConfiguration(DynamicConfigExpiration.class).build()).withSetterParameterDefinition("extensions", AttributeDefinition.Builder.fromChildCollectionConfiguration(Object.class).build()).withSetterParameterDefinition(INHERIT_ITERABLE_REPEATABILITY, AttributeDefinition.Builder.fromSimpleParameter((String)INHERIT_ITERABLE_REPEATABILITY).build()).withRegistrationName("_muleConfiguration").alwaysEnabled(true).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("dynamic-config-expiration").withTypeDefinition(TypeDefinition.fromType(DynamicConfigExpiration.class)).withObjectFactoryType(DynamicConfigExpirationObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"frequency").withDefaultValue((Object)ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getTime()).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"timeUnit", value -> TimeUnit.valueOf((String)value)).withDefaultValue((Object)ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getUnit()).build()).withSetterParameterDefinition("expirationPolicy", AttributeDefinition.Builder.fromChildConfiguration(ExpirationPolicy.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("expiration-policy").withTypeDefinition(TypeDefinition.fromType(ExpirationPolicy.class)).withObjectFactoryType(ExpirationPolicyObjectFactory.class).withSetterParameterDefinition("maxIdleTime", AttributeDefinition.Builder.fromSimpleParameter((String)"maxIdleTime").withDefaultValue((Object)ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getTime()).build()).withSetterParameterDefinition("timeUnit", AttributeDefinition.Builder.fromSimpleParameter((String)"timeUnit", value -> TimeUnit.valueOf((String)value)).withDefaultValue((Object)ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getUnit()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("notifications").withTypeDefinition(TypeDefinition.fromType(ServerNotificationManagerConfigurator.class)).withSetterParameterDefinition("notificationDynamic", AttributeDefinition.Builder.fromSimpleParameter((String)"dynamic").build()).withSetterParameterDefinition("enabledNotifications", AttributeDefinition.Builder.fromChildCollectionConfiguration(NotificationConfig.EnabledNotificationConfig.class).build()).withSetterParameterDefinition("disabledNotifications", AttributeDefinition.Builder.fromChildCollectionConfiguration(NotificationConfig.DisabledNotificationConfig.class).build()).withSetterParameterDefinition("notificationListeners", AttributeDefinition.Builder.fromChildCollectionConfiguration(ListenerSubscriptionPair.class).build()).alwaysEnabled(true).build());
        ComponentBuildingDefinition.Builder baseNotificationDefinition = baseDefinition.withSetterParameterDefinition("interfaceName", AttributeDefinition.Builder.fromSimpleParameter((String)"interface").build()).withSetterParameterDefinition("eventName", AttributeDefinition.Builder.fromSimpleParameter((String)"event").build()).withSetterParameterDefinition("interfaceClass", AttributeDefinition.Builder.fromSimpleParameter((String)"interface-class").build()).withSetterParameterDefinition("eventClass", AttributeDefinition.Builder.fromSimpleParameter((String)"event-class").build());
        componentBuildingDefinitions.add(baseNotificationDefinition.withTypeDefinition(TypeDefinition.fromType(NotificationConfig.EnabledNotificationConfig.class)).withIdentifier("notification").build());
        componentBuildingDefinitions.add(baseNotificationDefinition.withTypeDefinition(TypeDefinition.fromType(NotificationConfig.DisabledNotificationConfig.class)).withIdentifier("disable-notification").build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("notification-listener").withTypeDefinition(TypeDefinition.fromType(ListenerSubscriptionPair.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"subscription", this.getNotificationSubscriptionConverter()).withDefaultValue((Object)"*").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("username-password-filter").withTypeDefinition(TypeDefinition.fromType(UsernamePasswordAuthenticationFilter.class)).withSetterParameterDefinition("username", AttributeDefinition.Builder.fromSimpleParameter((String)"username").build()).withSetterParameterDefinition("password", AttributeDefinition.Builder.fromSimpleParameter((String)"password").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("custom-security-filter").withTypeDefinition(TypeDefinition.fromType(Processor.class)).withObjectFactoryType(CustomSecurityFilterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("encryption-security-filter").withTypeDefinition(TypeDefinition.fromType(MuleEncryptionEndpointSecurityFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"strategy-ref").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("security-manager").withTypeDefinition(TypeDefinition.fromType(SecurityManager.class)).withObjectFactoryType(MuleSecurityManagerConfigurator.class).withSetterParameterDefinition("muleContext", AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("providers", AttributeDefinition.Builder.fromChildCollectionConfiguration(SecurityProvider.class).build()).withSetterParameterDefinition("encryptionStrategies", AttributeDefinition.Builder.fromChildCollectionConfiguration(EncryptionStrategy.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("custom-security-provider").withTypeDefinition(TypeDefinition.fromType(CustomSecurityProviderDelegate.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"provider-ref").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("custom-encryption-strategy").withTypeDefinition(TypeDefinition.fromType(CustomEncryptionStrategyDelegate.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"strategy-ref").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("secret-key-encryption-strategy").withTypeDefinition(TypeDefinition.fromType(SecretKeyEncryptionStrategy.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("key", AttributeDefinition.Builder.fromSimpleParameter((String)"key").build()).withSetterParameterDefinition("keyFactory", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"keyFactory-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("password-encryption-strategy").withTypeDefinition(TypeDefinition.fromType(PasswordBasedEncryptionStrategy.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("iterationCount", AttributeDefinition.Builder.fromSimpleParameter((String)"iterationCount").build()).withSetterParameterDefinition("password", AttributeDefinition.Builder.fromSimpleParameter((String)"password").build()).withSetterParameterDefinition("salt", AttributeDefinition.Builder.fromSimpleParameter((String)"salt").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("redelivery-policy").withTypeDefinition(TypeDefinition.fromType(IdempotentRedeliveryPolicy.class)).withSetterParameterDefinition("maxRedeliveryCount", AttributeDefinition.Builder.fromSimpleParameter((String)"maxRedeliveryCount").withDefaultValue((Object)5).build()).withSetterParameterDefinition("useSecureHash", AttributeDefinition.Builder.fromSimpleParameter((String)"useSecureHash").build()).withSetterParameterDefinition("messageDigestAlgorithm", AttributeDefinition.Builder.fromSimpleParameter((String)"messageDigestAlgorithm").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"idExpression").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"objectStore").build()).withSetterParameterDefinition("privateObjectStore", AttributeDefinition.Builder.fromChildConfiguration(ValueResolver.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("pooling-profile").withTypeDefinition(TypeDefinition.fromType(PoolingProfile.class)).withSetterParameterDefinition("maxActive", AttributeDefinition.Builder.fromSimpleParameter((String)"maxActive").build()).withSetterParameterDefinition("maxIdle", AttributeDefinition.Builder.fromSimpleParameter((String)"maxIdle").build()).withSetterParameterDefinition("exhaustedAction", AttributeDefinition.Builder.fromSimpleParameter((String)"exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS::get).build()).withSetterParameterDefinition("maxWait", AttributeDefinition.Builder.fromSimpleParameter((String)"maxWait").build()).withSetterParameterDefinition("evictionCheckIntervalMillis", AttributeDefinition.Builder.fromSimpleParameter((String)"evictionCheckIntervalMillis").build()).withSetterParameterDefinition("minEvictionMillis", AttributeDefinition.Builder.fromSimpleParameter((String)"minEvictionMillis").build()).withSetterParameterDefinition("disabled", AttributeDefinition.Builder.fromSimpleParameter((String)"disabled").build()).withSetterParameterDefinition("initialisationPolicy", AttributeDefinition.Builder.fromSimpleParameter((String)"initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES::get).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("expression-component").withTypeDefinition(TypeDefinition.fromType(ExpressionLanguageComponent.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromTextContent().build()).withSetterParameterDefinition("expressionFile", AttributeDefinition.Builder.fromSimpleParameter((String)"file").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("invoke").withTypeDefinition(TypeDefinition.fromType(InvokerMessageProcessor.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("methodName", AttributeDefinition.Builder.fromSimpleParameter((String)"method").build()).withSetterParameterDefinition("argumentExpressionsString", AttributeDefinition.Builder.fromSimpleParameter((String)"methodArguments").build()).withSetterParameterDefinition("object", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"object-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("expression-language").withTypeDefinition(TypeDefinition.fromType(MVELExpressionLanguage.class)).withObjectFactoryType(MVELExpressionLanguageObjectFactory.class).withSetterParameterDefinition("autoResolveVariables", AttributeDefinition.Builder.fromSimpleParameter((String)"autoResolveVariables").build()).withSetterParameterDefinition("globalFunctions", AttributeDefinition.Builder.fromChildConfiguration(MVELGlobalFunctionsConfig.class).build()).withSetterParameterDefinition("imports", AttributeDefinition.Builder.fromChildCollectionConfiguration(ImportEntry.class).build()).withSetterParameterDefinition("aliases", AttributeDefinition.Builder.fromChildCollectionConfiguration(AliasEntry.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("import").withTypeDefinition(TypeDefinition.fromType(ImportEntry.class)).withSetterParameterDefinition("key", AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE, (TypeConverter)CommonTypeConverters.stringToClassConverter()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("alias").withTypeDefinition(TypeDefinition.fromType(AliasEntry.class)).withSetterParameterDefinition("key", AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("global-functions").withTypeDefinition(TypeDefinition.fromType(MVELGlobalFunctionsConfig.class)).withSetterParameterDefinition("file", AttributeDefinition.Builder.fromSimpleParameter((String)"file").build()).withSetterParameterDefinition("inlineScript", AttributeDefinition.Builder.fromTextContent().build()).build());
        componentBuildingDefinitions.addAll(this.getTransformersBuildingDefinitions());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(RAISE_ERROR).withTypeDefinition(TypeDefinition.fromType(RaiseErrorProcessor.class)).withSetterParameterDefinition(TYPE, AttributeDefinition.Builder.fromSimpleParameter((String)TYPE).build()).withSetterParameterDefinition("description", AttributeDefinition.Builder.fromSimpleParameter((String)"description").build()).build());
        componentBuildingDefinitions.addAll(this.getStreamingDefinitions());
        componentBuildingDefinitions.addAll(this.getIdempotentValidatorsDefinitions());
        componentBuildingDefinitions.addAll(this.getReconnectionDefinitions());
        componentBuildingDefinitions.addAll(this.getTransactionDefinitions());
        return componentBuildingDefinitions;
    }

    private TypeConverter<String, TransactionType> getTransactionTypeConverter() {
        return TransactionType::valueOf;
    }

    private TypeConverter<String, Predicate<? extends Notification>> getNotificationSubscriptionConverter() {
        return subscription -> {
            if ("*".equals(subscription)) {
                return n -> true;
            }
            return notification -> subscription != null ? subscription.equals(((AbstractServerNotification)notification).getResourceIdentifier()) : true;
        };
    }

    private List<ComponentBuildingDefinition> getIdempotentValidatorsDefinitions() {
        LinkedList<ComponentBuildingDefinition> definitions = new LinkedList<ComponentBuildingDefinition>();
        ComponentBuildingDefinition.Builder baseIdempotentMessageFilterDefinition = baseDefinition.withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"idExpression").build()).withSetterParameterDefinition("valueExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"valueExpression").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter((String)"storePrefix").build()).withSetterParameterDefinition("throwOnUnaccepted", AttributeDefinition.Builder.fromSimpleParameter((String)"throwOnUnaccepted").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"objectStore").build()).withSetterParameterDefinition("unacceptedMessageProcessor", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"onUnaccepted").build()).withSetterParameterDefinition("privateObjectStore", AttributeDefinition.Builder.fromChildConfiguration(ValueResolver.class).build());
        definitions.add(baseIdempotentMessageFilterDefinition.withIdentifier("idempotent-message-validator").withTypeDefinition(TypeDefinition.fromType(IdempotentMessageValidator.class)).build());
        return definitions;
    }

    private List<ComponentBuildingDefinition> getTransformersBuildingDefinitions() {
        ArrayList<ComponentBuildingDefinition> transformerComponentBuildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ByteArrayToObject.class).withIdentifier("byte-array-to-object-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToByteArray.class).withIdentifier("object-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToString.class).withIdentifier("object-to-string-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ByteArrayToSerializable.class).withIdentifier("byte-array-to-serializable-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(SerializableToByteArray.class).withIdentifier("serializable-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToString.class).withIdentifier("byte-array-to-string-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToByteArray.class).withIdentifier("string-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(baseDefinition.withIdentifier("parse-template").withTypeDefinition(TypeDefinition.fromType(ParseTemplateProcessor.class)).withSetterParameterDefinition("content", AttributeDefinition.Builder.fromChildConfiguration(String.class).withIdentifier("content").build()).withSetterParameterDefinition("outputMimeType", AttributeDefinition.Builder.fromSimpleParameter((String)"outputMimeType").build()).withSetterParameterDefinition("outputEncoding", AttributeDefinition.Builder.fromSimpleParameter((String)"outputEncoding").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter((String)"target").build()).withSetterParameterDefinition("location", AttributeDefinition.Builder.fromSimpleParameter((String)"location").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter((String)"targetValue").build()).build());
        transformerComponentBuildingDefinitions.add(this.getCoreMuleMessageTransformerBaseBuilder().withIdentifier("content").withTypeDefinition(TypeDefinition.fromType(String.class)).build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(AutoTransformer.class).withIdentifier("auto-transformer").build());
        transformerComponentBuildingDefinitions.add(ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(this.getCustomTransformerConfigurationFactory(), Transformer.class, KeyAttributeDefinitionPair.newBuilder().withKey(CLASS_ATTRIBUTE).withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE).build()).build()).withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).withIdentifier("custom-transformer").withNamespace("mule").build());
        return transformerComponentBuildingDefinitions;
    }

    private ConfigurableInstanceFactory getAddVariableTransformerInstanceFactory(Class<? extends AbstractAddVariablePropertyProcessor> transformerType) {
        return parameters -> {
            AbstractAddVariablePropertyProcessor transformer = (AbstractAddVariablePropertyProcessor)ComponentBuildingDefinitionProviderUtils.createNewInstance(transformerType);
            transformer.setIdentifier((String)parameters.get("identifier"));
            transformer.setValue((String)parameters.get("value"));
            return transformer;
        };
    }

    private ConfigurableInstanceFactory getEncryptionTransformerConfigurationFactory(Class<? extends AbstractEncryptionTransformer> abstractEncryptionTransformerType) {
        return parameters -> {
            AbstractEncryptionTransformer encryptionTransformer = (AbstractEncryptionTransformer)ComponentBuildingDefinitionProviderUtils.createNewInstance(abstractEncryptionTransformerType);
            encryptionTransformer.setStrategy((EncryptionStrategy)parameters.get("strategy"));
            return encryptionTransformer;
        };
    }

    private ConfigurableInstanceFactory getCustomTransformerConfigurationFactory() {
        return parameters -> {
            String className = (String)parameters.get(CLASS_ATTRIBUTE);
            Preconditions.checkState((className != null ? 1 : 0) != 0, (String)"custom-transformer class attribute cannot be null");
            return ComponentBuildingDefinitionProviderUtils.createNewInstance(className);
        };
    }

    private static ComponentBuildingDefinition.Builder getSetVariablePropertyBaseBuilder(ConfigurableInstanceFactory configurableInstanceFactory, Class<? extends AbstractAddVariablePropertyProcessor> setterClass, KeyAttributeDefinitionPair ... configurationAttributes) {
        Object[] commonTransformerParameters = new KeyAttributeDefinitionPair[]{KeyAttributeDefinitionPair.newBuilder().withKey("encoding").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"encoding").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("mimeType").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"mimeType").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build()};
        return baseDefinition.withTypeDefinition(TypeDefinition.fromType(setterClass)).withObjectFactoryType(((Object)((Object)new ConfigurableObjectFactory())).getClass()).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)configurableInstanceFactory).build()).withSetterParameterDefinition("commonConfiguratorType", AttributeDefinition.Builder.fromFixedValue(AddVariablePropertyConfigurator.class).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])((KeyAttributeDefinitionPair[])ArrayUtils.addAll((Object[])commonTransformerParameters, (Object[])configurationAttributes))).build()).asPrototype();
    }

    private long getDefaultSchedulerFixedFrequency() {
        String freq = System.getProperty("mule.config.scheduler.defaultFixedFrequency", "1000");
        try {
            return Long.valueOf(freq);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value for System Property %s. A long number was expected but '%s' found instead", "mule.config.scheduler.defaultFixedFrequency", freq));
        }
    }

    private List<ComponentBuildingDefinition> getStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.addAll(this.getBytesStreamingDefinitions());
        buildingDefinitions.addAll(this.getObjectsStreamingDefinitions());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getBytesStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.withIdentifier("repeatable-in-memory-stream").withTypeDefinition(TypeDefinition.fromType(CursorStreamProviderFactory.class)).withObjectFactoryType(InMemoryCursorStreamProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"initialBufferSize").withDefaultValue((Object)512).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"bufferSizeIncrement").withDefaultValue((Object)512).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxBufferSize").withDefaultValue((Object)1024).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"bufferUnit", value -> DataUnit.valueOf((String)((String)value))).withDefaultValue((Object)ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT.name()).build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("non-repeatable-stream").withTypeDefinition(TypeDefinition.fromType(CursorStreamProviderFactory.class)).withObjectFactoryType(NullCursorStreamProviderObjectFactory.class).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getObjectsStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.withIdentifier("repeatable-in-memory-iterable").withTypeDefinition(TypeDefinition.fromType(CursorIteratorProviderFactory.class)).withObjectFactoryType(InMemoryCursorIteratorProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"initialBufferSize").withDefaultValue((Object)100).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"bufferSizeIncrement").withDefaultValue((Object)100).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxBufferSize").withDefaultValue((Object)500).build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("non-repeatable-iterable").withTypeDefinition(TypeDefinition.fromType(CursorIteratorProviderFactory.class)).withObjectFactoryType(NullCursorIteratorProviderObjectFactory.class).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getReconnectionDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        ComponentBuildingDefinition.Builder baseReconnectDefinition = baseDefinition.withTypeDefinition(TypeDefinition.fromType(RetryPolicyTemplate.class)).withObjectFactoryType(RetryPolicyTemplateObjectFactory.class).withSetterParameterDefinition("blocking", AttributeDefinition.Builder.fromSimpleParameter((String)"blocking").build()).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter((String)"frequency").build());
        buildingDefinitions.add(baseReconnectDefinition.withIdentifier("reconnect-forever").withSetterParameterDefinition("count", AttributeDefinition.Builder.fromFixedValue((Object)-1).build()).build());
        buildingDefinitions.add(baseReconnectDefinition.withIdentifier("reconnect").withSetterParameterDefinition("retryNotifier", AttributeDefinition.Builder.fromChildConfiguration(RetryNotifier.class).build()).withSetterParameterDefinition("count", AttributeDefinition.Builder.fromSimpleParameter((String)"count").build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("reconnection").withTypeDefinition(TypeDefinition.fromType(ReconnectionConfig.class)).withObjectFactoryType(ReconnectionConfigObjectFactory.class).withSetterParameterDefinition("failsDeployment", AttributeDefinition.Builder.fromSimpleParameter((String)"failsDeployment").build()).withSetterParameterDefinition("retryPolicyTemplate", AttributeDefinition.Builder.fromChildConfiguration(RetryPolicyTemplate.class).build()).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getTransactionDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.withIdentifier("xa-transaction").withTypeDefinition(TypeDefinition.fromType(MuleTransactionConfig.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)new XaTransactionFactory()).build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("actionAsString", AttributeDefinition.Builder.fromSimpleParameter((String)"action").build()).withSetterParameterDefinition("interactWithExternal", AttributeDefinition.Builder.fromSimpleParameter((String)"interactWithExternal").build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("environment").withTypeDefinition(TypeDefinition.fromType(Map.class)).withObjectFactoryType(EnvironmentPropertyObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).build());
        return buildingDefinitions;
    }

    private ComponentBuildingDefinition.Builder getCoreTransformerBaseBuilder(Class<? extends AbstractTransformer> transformerClass) {
        return ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(transformerClass, new KeyAttributeDefinitionPair[0]).withNamespace("mule");
    }

    private ComponentBuildingDefinition.Builder getCoreMuleMessageTransformerBaseBuilder() {
        return ComponentBuildingDefinitionProviderUtils.getMuleMessageTransformerBaseBuilder().withNamespace("mule");
    }
}

