/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import java.util.Optional;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.metadata.DslElementBasedValueProviderCacheIdGenerator;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheIdGenerator;

public class ComponentBasedValueProviderCacheIdGenerator
implements ValueProviderCacheIdGenerator<ComponentAst> {
    private final DslElementModelFactory elementModelFactory;
    private final DslElementBasedValueProviderCacheIdGenerator delegate;

    public ComponentBasedValueProviderCacheIdGenerator(DslResolvingContext context, ComponentLocator<ComponentAst> locator) {
        this.elementModelFactory = DslElementModelFactory.getDefault(context);
        this.delegate = new DslElementBasedValueProviderCacheIdGenerator(location -> locator.get(location).map(c -> this.elementModelFactory.create((ComponentAst)c).orElse(null)));
    }

    public Optional<ValueProviderCacheId> getIdForResolvedValues(ComponentAst containerComponent, String parameterName) {
        Preconditions.checkArgument((containerComponent != null ? 1 : 0) != 0, (String)"Cannot generate a Cache Key for a 'null' component");
        if (this.isConnection(containerComponent)) {
            return this.getConnectionModel(containerComponent).flatMap(connection -> this.delegate.getIdForResolvedValues((DslElementModel<?>)connection, parameterName));
        }
        return this.elementModelFactory.create(containerComponent).flatMap(e -> this.delegate.getIdForResolvedValues((DslElementModel<?>)e, parameterName));
    }

    private boolean isConnection(ComponentAst componentAst) {
        return componentAst.getModel(ConnectionProviderModel.class).isPresent();
    }

    private Optional<DslElementModel> getConnectionModel(ComponentAst componentAst) {
        if (componentAst instanceof ComponentModel) {
            return this.elementModelFactory.create(((ComponentModel)componentAst).getParent().getConfiguration()).flatMap(configModel -> configModel.getContainedElements().stream().filter(contained -> contained.getModel() instanceof ConnectionProviderModel).findAny());
        }
        return Optional.empty();
    }
}

