/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.springframework.beans.factory.FactoryBean;

public class ConstantFactoryBean<T>
extends AbstractComponent
implements FactoryBean<T> {
    @Inject
    private MuleContext muleContext;
    private final T value;

    public ConstantFactoryBean(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.value = value;
    }

    public T getObject() throws Exception {
        if (this.value instanceof Component) {
            ((Component)this.value).setAnnotations(this.getAnnotations());
        }
        this.muleContext.getInjector().inject(this.value);
        return this.value;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return this.value.getClass();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

