/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.XmlDslElementModelConverter;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.internal.dsl.DslConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultXmlDslElementModelConverter
implements XmlDslElementModelConverter {
    private static final List<String> INFRASTRUCTURE_NAMES = Arrays.asList("config-ref", "name", "pooling-profile", "reconnection", "reconnect-forever", "redelivery-policy", "context", "tlsContext", "poolingProfile", "reconnectionStrategy", "redeliveryPolicy", "target");
    private static final String XMLNS_ATTRIBUTE_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS = "xmlns:";
    private final Document doc;

    public DefaultXmlDslElementModelConverter(Document owner) {
        this.doc = owner;
    }

    @Override
    public Element asXml(DslElementModel elementModel) {
        Object model = elementModel.getModel();
        Preconditions.checkArgument((model instanceof ConfigurationModel || model instanceof ComponentModel || model instanceof MetadataType ? 1 : 0) != 0, (String)"The element must be either a MetadataType, ConfigurationModel or a ComponentModel");
        DslElementSyntax dsl = elementModel.getDsl();
        Element componentRoot = this.createElement(dsl, elementModel.getConfiguration());
        if (this.isEETransform(componentRoot)) {
            return this.populateEETransform(elementModel);
        }
        this.writeApplicationElement(componentRoot, elementModel, componentRoot);
        return componentRoot;
    }

    private String getPrefix(DslElementSyntax dsl, ComponentConfiguration configuration) {
        return configuration.getProperty("DECLARED_PREFIX").isPresent() ? configuration.getProperty("DECLARED_PREFIX").get().toString() : dsl.getPrefix();
    }

    private void writeApplicationElement(Element element, DslElementModel<?> elementModel, Element parentNode) {
        if (elementModel.getModel() instanceof ConfigurationModel) {
            this.populateConnectionProviderConfiguration(element, elementModel);
        }
        this.populateInfrastructureConfiguration(element, elementModel);
        if (elementModel.getContainedElements().isEmpty() && elementModel.getValue().isPresent()) {
            this.setTextContentElement(element, elementModel, parentNode);
            return;
        }
        elementModel.getContainedElements().stream().filter(c -> !this.isInfrastructure((DslElementModel)c) && !this.isConnectionProvider((DslElementModel)c)).filter(c -> !this.isInfrastructure((DslElementModel)c)).forEach(inner -> {
            DslElementSyntax innerDsl = inner.getDsl();
            Reference configured = new Reference((Object)false);
            if (innerDsl.supportsAttributeDeclaration() && inner.getValue().isPresent()) {
                this.getCustomizedValue((DslElementModel)inner).ifPresent(value -> {
                    configured.set((Object)true);
                    element.setAttribute(innerDsl.getAttributeName(), (String)value);
                });
            }
            if (!((Boolean)configured.get()).booleanValue() && innerDsl.supportsChildDeclaration() && inner.isExplicitInDsl()) {
                Element childElement = this.createElement(innerDsl, inner.getConfiguration());
                if (this.isEETransform(childElement)) {
                    element.appendChild(this.populateEETransform((DslElementModel<?>)inner));
                } else {
                    this.writeApplicationElement(childElement, (DslElementModel<?>)inner, element);
                }
            }
        });
        if (parentNode != element) {
            parentNode.appendChild(element);
        }
    }

    private boolean isEETransform(Element parentNode) {
        return parentNode.getNamespaceURI().equals(DslConstants.EE_NAMESPACE) && parentNode.getNodeName().equals("ee:transform");
    }

    private Element createElement(DslElementSyntax dsl, Optional<ComponentConfiguration> configuration) {
        return configuration.isPresent() ? this.createElement(dsl.getElementName(), this.getPrefix(dsl, configuration.get()), dsl.getNamespace()) : this.createElement(dsl);
    }

    private void setTextContentElement(Element element, DslElementModel<?> elementModel, Element parentNode) {
        this.getCustomizedValue(elementModel).ifPresent(value -> {
            DslElementSyntax dsl = elementModel.getDsl();
            if (dsl.supportsChildDeclaration() && !dsl.supportsAttributeDeclaration()) {
                if (elementModel.getConfiguration().map(c -> c.getProperty("IS_CDATA").isPresent()).orElse(false).booleanValue()) {
                    element.appendChild(this.doc.createCDATASection((String)value));
                } else {
                    element.setTextContent((String)value);
                }
                if (parentNode != element) {
                    parentNode.appendChild(element);
                }
            } else {
                parentNode.setAttribute(dsl.getAttributeName(), (String)value);
            }
        });
    }

    private Optional<String> getCustomizedValue(DslElementModel elementModel) {
        String value = elementModel.getValue().get();
        if (elementModel.isExplicitInDsl()) {
            return Optional.of(value);
        }
        Optional<String> defaultValue = this.getDefaultValue(elementModel.getDsl().getAttributeName(), elementModel.getModel());
        if (!defaultValue.isPresent() || !defaultValue.get().equals(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private Optional<String> getDefaultValue(String name, Object model) {
        if (model instanceof ParameterModel) {
            return ExtensionModelUtils.getDefaultValue((ParameterModel)((ParameterModel)model));
        }
        return ExtensionModelUtils.getDefaultValue((String)name, (MetadataType)((MetadataType)model));
    }

    private Element createElement(DslElementSyntax dsl) {
        return this.createElement(dsl.getElementName(), dsl.getPrefix(), dsl.getNamespace());
    }

    private Element createElement(DslElementSyntax dsl, String name) {
        return this.createElement(name, dsl.getPrefix(), dsl.getNamespace());
    }

    private Element createElement(String name, String prefix, String namespace) {
        if (!prefix.equals("mule")) {
            this.addNamespaceDeclarationIfNeeded(prefix, namespace, XmlModelUtils.buildSchemaLocation((String)prefix, (String)namespace));
            return this.doc.createElementNS(namespace, prefix + ":" + name);
        }
        this.doc.getDocumentElement().setAttributeNS(XMLNS_ATTRIBUTE_NAMESPACE, "xmlns", DslConstants.CORE_NAMESPACE);
        return this.doc.createElementNS(DslConstants.CORE_NAMESPACE, name);
    }

    private boolean isConnectionProvider(DslElementModel elementModel) {
        return elementModel.getModel() instanceof ConnectionProviderModel;
    }

    private boolean isInfrastructure(DslElementModel elementModel) {
        Object model = elementModel.getModel();
        if (model instanceof ParameterModel) {
            return ExtensionModelUtils.isInfrastructure((ParameterModel)((ParameterModel)model));
        }
        return INFRASTRUCTURE_NAMES.contains(elementModel.getDsl().getAttributeName()) || INFRASTRUCTURE_NAMES.contains(elementModel.getDsl().getElementName());
    }

    private void populateInfrastructureConfiguration(Element element, DslElementModel<?> elementModel) {
        elementModel.getContainedElements().stream().filter(this::isInfrastructure).forEach(e -> {
            if (e.getContainedElements().isEmpty() && e.getValue().isPresent()) {
                element.setAttribute(e.getDsl().getAttributeName(), e.getValue().get());
            } else {
                Optional<ComponentConfiguration> config = e.getConfiguration();
                config.ifPresent(c -> {
                    if (c.getIdentifier().getNamespace().contains("tls")) {
                        element.appendChild(this.createTLS((ComponentConfiguration)c));
                    } else if (c.getIdentifier().getNamespace().contains("ee")) {
                        element.appendChild(this.createEE((ComponentConfiguration)c));
                    } else {
                        element.appendChild(this.clone((ComponentConfiguration)c));
                    }
                });
            }
        });
        elementModel.getConfiguration().ifPresent(c -> Stream.of("name", "config-ref").forEach(name -> {
            String value = (String)c.getParameters().get(name);
            if (!StringUtils.isBlank((CharSequence)value)) {
                element.setAttribute((String)name, value);
            }
        }));
    }

    private void populateConnectionProviderConfiguration(Element element, DslElementModel<?> elementModel) {
        elementModel.getContainedElements().stream().filter(this::isConnectionProvider).findFirst().ifPresent(e -> {
            DslElementSyntax innerDsl = e.getDsl();
            Element childElement = this.createElement(innerDsl, e.getConfiguration());
            this.writeApplicationElement(childElement, (DslElementModel<?>)e, element);
        });
    }

    private Element populateEETransform(DslElementModel<?> elementModel) {
        Element transform = this.createElement(elementModel.getDsl());
        elementModel.getConfiguration().ifPresent(c -> c.getParameters().forEach((name, value) -> elementModel.findElement((String)name).filter(DslElementModel::isExplicitInDsl).ifPresent(e -> transform.setAttribute((String)name, (String)value))));
        elementModel.findElement(ComponentIdentifier.buildFromStringRepresentation((String)"ee:set-payload")).filter(DslElementModel::isExplicitInDsl).ifPresent(message -> {
            Element messageElement = this.createElement(elementModel.getDsl(), "message");
            transform.appendChild(messageElement);
            elementModel.findElement(ComponentIdentifier.buildFromStringRepresentation((String)"ee:set-payload")).ifPresent(setPayload -> setPayload.getConfiguration().ifPresent(c -> messageElement.appendChild(this.createTransformTextElement((ComponentConfiguration)c))));
            elementModel.findElement(ComponentIdentifier.buildFromStringRepresentation((String)"ee:set-attributes")).ifPresent(setAttributes -> setAttributes.getConfiguration().ifPresent(c -> messageElement.appendChild(this.createTransformTextElement((ComponentConfiguration)c))));
        });
        elementModel.findElement(ComponentIdentifier.buildFromStringRepresentation((String)"ee:set-variables")).ifPresent(variables -> {
            Element variablesList = this.createElement(elementModel.getDsl(), "variables");
            transform.appendChild(variablesList);
            variables.getContainedElements().forEach(variable -> variable.getConfiguration().ifPresent(c -> {
                Element var = this.createTransformTextElement((ComponentConfiguration)c);
                var.setAttribute("variableName", (String)((ComponentConfiguration)c).getParameters().get("variableName"));
                variablesList.appendChild(var);
            }));
        });
        return transform;
    }

    private Element createTLS(ComponentConfiguration config) {
        String namespaceURI = "http://www.mulesoft.org/schema/mule/tls";
        String tlsSchemaLocation = "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd";
        this.addNamespaceDeclarationIfNeeded("tls", namespaceURI, tlsSchemaLocation);
        Element nested = this.doc.createElementNS(namespaceURI, "tls:" + config.getIdentifier().getName());
        config.getParameters().forEach(nested::setAttribute);
        config.getNestedComponents().forEach(inner -> nested.appendChild(this.createTLS((ComponentConfiguration)inner)));
        return nested;
    }

    private Element createEE(ComponentConfiguration config) {
        String namespaceURI = DslConstants.EE_NAMESPACE;
        String eeSchemaLocation = XmlModelUtils.buildSchemaLocation((String)"ee", (String)DslConstants.EE_NAMESPACE);
        this.addNamespaceDeclarationIfNeeded("ee", namespaceURI, eeSchemaLocation);
        Element nested = this.doc.createElementNS(namespaceURI, "ee:" + config.getIdentifier().getName());
        config.getParameters().forEach(nested::setAttribute);
        config.getNestedComponents().forEach(inner -> nested.appendChild(this.clone((ComponentConfiguration)inner)));
        return nested;
    }

    private Element createTransformTextElement(ComponentConfiguration config) {
        String namespaceURI = DslConstants.EE_NAMESPACE;
        String eeSchemaLocation = XmlModelUtils.buildSchemaLocation((String)"ee", (String)DslConstants.EE_NAMESPACE);
        this.addNamespaceDeclarationIfNeeded("ee", namespaceURI, eeSchemaLocation);
        Element nested = this.doc.createElementNS(namespaceURI, "ee:" + config.getIdentifier().getName());
        config.getParameters().forEach(nested::setAttribute);
        config.getNestedComponents().stream().filter(inner -> inner.getValue().isPresent()).forEach(inner -> nested.appendChild(this.doc.createCDATASection((String)inner.getValue().get())));
        return nested;
    }

    private void addNamespaceDeclarationIfNeeded(String prefix, String namespaceURI, String schemaLocation) {
        if (StringUtils.isBlank((CharSequence)this.doc.getDocumentElement().getAttributeNS(XMLNS_ATTRIBUTE_NAMESPACE, XMLNS + prefix))) {
            this.doc.getDocumentElement().setAttributeNS(XMLNS_ATTRIBUTE_NAMESPACE, XMLNS + prefix, namespaceURI);
            this.addSchemaLocationIfNeeded(namespaceURI, schemaLocation);
        }
    }

    private void addSchemaLocationIfNeeded(String namespaceURI, String schemaLocation) {
        Attr schemaLocationAttribute = this.doc.getDocumentElement().getAttributeNode("xsi:schemaLocation");
        if (schemaLocationAttribute != null && !schemaLocationAttribute.getValue().contains(namespaceURI)) {
            this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocationAttribute.getValue() + " " + namespaceURI + " " + schemaLocation);
        }
    }

    private Element clone(ComponentConfiguration config) {
        Element element = this.doc.createElement(config.getIdentifier().getName());
        config.getParameters().forEach(element::setAttribute);
        config.getNestedComponents().forEach(nested -> element.appendChild(this.clone((ComponentConfiguration)nested)));
        return element;
    }
}

