/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.ConfigFile;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.api.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.internal.ArtifactConfigResolver;
import org.mule.runtime.config.internal.ArtifactConfigResolverContext;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.config.RuntimeConfigurationException;
import org.mule.runtime.core.api.config.ConfigResource;
import org.w3c.dom.Document;

public class DefaultArtifactConfigResolver
implements ArtifactConfigResolver {
    @Override
    public ArtifactConfig resolveArtifactConfig(ArtifactConfigResolverContext context) {
        ArtifactConfig.Builder applicationConfigBuilder = new ArtifactConfig.Builder();
        applicationConfigBuilder.setArtifactProperties(context.getArtifactProperties());
        if (!ArrayUtils.isEmpty((Object[])context.getArtifactConfigResources())) {
            ArrayList<Pair<String, Supplier<InputStream>>> initialConfigFiles = new ArrayList<Pair<String, Supplier<InputStream>>>();
            for (ConfigResource artifactConfigResource : context.getArtifactConfigResources()) {
                initialConfigFiles.add((Pair<String, Supplier<InputStream>>)new Pair((Object)artifactConfigResource.getResourceName(), () -> {
                    try {
                        return artifactConfigResource.getInputStream();
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }));
            }
            ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
            this.recursivelyResolveConfigFiles(initialConfigFiles, configFiles, context).forEach(applicationConfigBuilder::addConfigFile);
        }
        applicationConfigBuilder.setApplicationName(context.getArtifactName());
        return applicationConfigBuilder.build();
    }

    private List<ConfigFile> recursivelyResolveConfigFiles(List<Pair<String, Supplier<InputStream>>> configFilesToResolve, List<ConfigFile> alreadyResolvedConfigFiles, ArtifactConfigResolverContext context) {
        DefaultConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new EnvironmentPropertiesConfigurationProvider());
        ImmutableList.Builder resolvedConfigFilesBuilder = ImmutableList.builder().addAll(alreadyResolvedConfigFiles);
        configFilesToResolve.stream().filter(fileNameInputStreamPair -> !alreadyResolvedConfigFiles.stream().anyMatch(configFile -> configFile.getFilename().equals(fileNameInputStreamPair.getFirst()))).forEach(fileNameInputStreamPair -> {
            InputStream is = null;
            try {
                is = (InputStream)((Supplier)fileNameInputStreamPair.getSecond()).get();
                Document document = context.getXmlConfigurationDocumentLoader().loadDocument(context.getExtensions(), (String)fileNameInputStreamPair.getFirst(), is);
                ConfigLine mainConfigLine = context.getXmlApplicationParser().parse(document.getDocumentElement()).get();
                ConfigFile configFile = new ConfigFile((String)fileNameInputStreamPair.getFirst(), Arrays.asList(mainConfigLine));
                resolvedConfigFilesBuilder.add((Object)configFile);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }
            }
        });
        ImmutableSet.Builder importedFiles = ImmutableSet.builder();
        for (ConfigFile configFile : resolvedConfigFilesBuilder.build()) {
            List<ConfigLine> rootConfigLines = configFile.getConfigLines();
            ConfigLine muleRootElementConfigLine = rootConfigLines.get(0);
            importedFiles.addAll((Iterable)muleRootElementConfigLine.getChildren().stream().filter(configLine -> configLine.getNamespace().equals("mule") && configLine.getIdentifier().equals("import")).map(configLine -> {
                SimpleConfigAttribute fileConfigAttribute = configLine.getConfigAttributes().get("file");
                if (fileConfigAttribute == null) {
                    throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("<import> does not have a file attribute defined. At file '%s', at line %s", configFile.getFilename(), configLine.getLineNumber())));
                }
                return fileConfigAttribute.getValue();
            }).map(value -> (String)propertyResolver.resolveValue((String)value)).filter(fileName -> !alreadyResolvedConfigFiles.stream().anyMatch(solvedConfigFile -> solvedConfigFile.getFilename().equals(fileName))).collect(Collectors.toList()));
        }
        ImmutableSet importedConfigurationFiles = importedFiles.build();
        if (importedConfigurationFiles.isEmpty()) {
            return resolvedConfigFilesBuilder.build();
        }
        List<Pair<String, Supplier<InputStream>>> newConfigFilesToResolved = importedConfigurationFiles.stream().map(importedFileName -> {
            ClassLoader classLoader = context.getExecutionClassLoader();
            if (classLoader.getResource((String)importedFileName) == null) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Could not find imported resource '%s'", importedFileName)));
            }
            return new Pair(importedFileName, () -> classLoader.getResourceAsStream((String)importedFileName));
        }).collect(Collectors.toList());
        return this.recursivelyResolveConfigFiles(newConfigFilesToResolved, (List<ConfigFile>)resolvedConfigFilesBuilder.build(), context);
    }
}

