/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.processor;

import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.privileged.transport.LegacyConnector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class MuleObjectNameProcessor
implements BeanPostProcessor {
    private boolean overwrite = false;
    private final Class<? extends NameableObject>[] managedTypes = new Class[]{LegacyConnector.class, Transformer.class};

    public Object postProcessBeforeInitialization(Object object, String beanName) throws BeansException {
        for (Class<? extends NameableObject> managedType : this.managedTypes) {
            if (!managedType.isInstance(object)) continue;
            this.setNameIfNecessary((NameableObject)object, beanName);
        }
        return object;
    }

    private void setNameIfNecessary(NameableObject nameable, String name) {
        if (nameable.getName() == null || this.overwrite) {
            nameable.setName(name);
        }
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

