/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class ObjectFactoryClassRepository {
    private Cache<ComponentBuildingDefinition, Class<ObjectFactory>> objectFactoryClassCache = CacheBuilder.newBuilder().removalListener(notification -> Enhancer.registerStaticCallbacks((Class)((Class)notification.getValue()), null)).build();

    public Class<ObjectFactory> getObjectFactoryClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction, Optional<Consumer<Object>> instancePostCreationFunctionOptional) {
        try {
            if (instancePostCreationFunctionOptional.isPresent()) {
                return this.getObjectFactoryDynamicClass(componentBuildingDefinition, objectFactoryType, createdObjectType, isLazyInitFunction, instancePostCreationFunctionOptional);
            }
            return (Class)this.objectFactoryClassCache.get((Object)componentBuildingDefinition, () -> this.getObjectFactoryDynamicClass(componentBuildingDefinition, objectFactoryType, createdObjectType, isLazyInitFunction, Optional.empty()));
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Class<ObjectFactory> getObjectFactoryDynamicClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction, Optional<Consumer<Object>> instancePostCreationFunction) {
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{SmartFactoryBean.class});
        enhancer.setSuperclass(objectFactoryType);
        enhancer.setCallbackType(MethodInterceptor.class);
        if (SmartFactoryBean.class.getClassLoader() != objectFactoryType.getClassLoader()) {
            enhancer.setClassLoader((ClassLoader)new CompositeClassLoader(ObjectFactoryClassRepository.class.getClassLoader(), new ClassLoader[]{objectFactoryType.getClassLoader()}));
        }
        enhancer.setUseCache(!instancePostCreationFunction.isPresent());
        Class factoryBeanClass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)factoryBeanClass, (Callback[])new Callback[]{(obj, method, args, proxy) -> {
            if (method.getName().equals("isSingleton")) {
                return !componentBuildingDefinition.isPrototype();
            }
            if (method.getName().equals("getObjectType") && !ObjectTypeProvider.class.isAssignableFrom(obj.getClass())) {
                return createdObjectType;
            }
            if (method.getName().equals("getObject")) {
                Object createdInstance = proxy.invokeSuper(obj, args);
                instancePostCreationFunction.ifPresent(consumer -> consumer.accept(createdInstance));
                return createdInstance;
            }
            if (method.getName().equals("isPrototype")) {
                return componentBuildingDefinition.isPrototype();
            }
            if (method.getName().equals("isEagerInit")) {
                return (Boolean)isLazyInitFunction.get() == false;
            }
            return proxy.invokeSuper(obj, args);
        }});
        return factoryBeanClass;
    }

    public void destroy() {
        this.objectFactoryClassCache.invalidateAll();
    }
}

