/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.chain.SubflowMessageProcessorChainBuilder;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;

public class FlowRefFactoryBean
extends AbstractComponentFactory<Processor>
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private String target;
    private String targetValue = "#[payload]";
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator locator;

    public void setName(String name) {
        this.refName = name;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public Processor doGetObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new IllegalArgumentException("flow-ref name is empty");
        }
        return new FlowRefMessageProcessor();
    }

    protected Processor getReferencedFlow(String name, FlowRefMessageProcessor flowRefMessageProcessor) throws MuleException {
        if (name == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage((String)"flow-ref name expression returned 'null'"), (Processor)flowRefMessageProcessor);
        }
        Component referencedFlow = this.getReferencedProcessor(name);
        if (referencedFlow == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage((String)"No flow/sub-flow with name '%s' found", (Object[])new Object[]{name}), (Processor)flowRefMessageProcessor);
        }
        if (!(referencedFlow instanceof Flow)) {
            if (referencedFlow instanceof SubflowMessageProcessorChainBuilder) {
                MessageProcessorChainBuilder chainBuilder = (MessageProcessorChainBuilder)referencedFlow;
                this.locator.find(flowRefMessageProcessor.getRootContainerLocation()).filter(c -> c instanceof Flow).map(c -> (Flow)c).ifPresent(f -> chainBuilder.setProcessingStrategy(f.getProcessingStrategy()));
                referencedFlow = chainBuilder.build();
            }
            LifecycleUtils.initialiseIfNeeded((Object)referencedFlow, (MuleContext)this.muleContext);
            HashMap<QName, String> annotations = new HashMap<QName, String>(referencedFlow.getAnnotations());
            annotations.put(ROOT_CONTAINER_NAME_KEY, this.getRootContainerLocation().toString());
            referencedFlow.setAnnotations(annotations);
            LifecycleUtils.startIfNeeded((Object)referencedFlow);
        }
        return (Processor)referencedFlow;
    }

    private Component getReferencedProcessor(String name) {
        if (this.applicationContext instanceof MuleArtifactContext) {
            MuleArtifactContext muleArtifactContext = (MuleArtifactContext)this.applicationContext;
            try {
                if (muleArtifactContext.getBeanFactory().getBeanDefinition(name).isPrototype()) {
                    muleArtifactContext.getPrototypeBeanWithRootContainer(name, this.getRootContainerLocation().toString());
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return (Component)this.applicationContext.getBean(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.muleContext.getInjector().inject((Object)this);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private class FlowRefMessageProcessor
    extends AbstractComponent
    implements AnnotatedProcessor,
    Stoppable,
    Disposable {
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, FlowRefMessageProcessor.this);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.expressionManager.isExpression(FlowRefFactoryBean.this.refName);
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor referencedProcessor;
                try {
                    referencedProcessor = this.resolveReferencedProcessor((CoreEvent)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                Flux flux = referencedProcessor instanceof Flow ? Flux.from((Publisher)MessageProcessors.processWithChildContext((CoreEvent)event, (ReactiveProcessor)referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()), (FlowExceptionHandler)((Flow)referencedProcessor).getExceptionListener())) : Flux.from((Publisher)MessageProcessors.processWithChildContext((CoreEvent)event, (ReactiveProcessor)referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation())));
                return flux.map(Operators.outputToTarget((CoreEvent)event, (String)FlowRefFactoryBean.this.target, (String)FlowRefFactoryBean.this.targetValue, (ExpressionLanguage)FlowRefFactoryBean.this.expressionManager));
            });
        }

        protected Processor resolveReferencedProcessor(CoreEvent event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.expressionManager.parse(FlowRefFactoryBean.this.refName, event, this.getLocation()) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                if (e.getCause() instanceof MuleException) {
                    throw (MuleException)e.getCause();
                }
                throw e;
            }
        }

        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded((Object)p);
            }
        }

        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded((Object)p, (Logger)LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

