/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.internal.ComponentModelInitializer;
import org.mule.runtime.config.internal.CompositeOptionalObjectsController;
import org.mule.runtime.config.internal.DefaultOptionalObjectsController;
import org.mule.runtime.config.internal.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringRegistry;
import org.mule.runtime.config.internal.artifact.SpringArtifactContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.internal.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder {
    private ArtifactDeclaration artifactDeclaration = new ArtifactDeclaration();
    private boolean enableLazyInit = false;
    private boolean disableXmlValidations = false;
    private SpringRegistry registry;
    private ApplicationContext parentContext;
    private MuleArtifactContext muleArtifactContext;
    private ArtifactType artifactType;

    public SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean disableXmlValidations) throws ConfigurationException {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
        this.enableLazyInit = enableLazyInit;
        this.disableXmlValidations = disableXmlValidations;
    }

    public SpringXmlConfigurationBuilder(String configResources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        this(new String[]{configResources}, artifactProperties, artifactType, false, false);
    }

    public SpringXmlConfigurationBuilder(String configResource) throws ConfigurationException {
        this(configResource, Collections.emptyMap(), ArtifactType.APP);
    }

    public SpringXmlConfigurationBuilder(String[] configFiles, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        this(configFiles, artifactProperties, artifactType, false, false);
    }

    public SpringXmlConfigurationBuilder(String[] configFiles, Map<String, String> artifactProperties) throws ConfigurationException {
        this(configFiles, artifactProperties, ArtifactType.APP, false, false);
    }

    public SpringXmlConfigurationBuilder(String[] configFiles, boolean enableLazyInit, boolean disableXmlValidations) throws ConfigurationException {
        super(configFiles, Collections.emptyMap());
        this.artifactType = ArtifactType.APP;
        this.enableLazyInit = enableLazyInit;
        this.disableXmlValidations = disableXmlValidations;
    }

    public SpringXmlConfigurationBuilder(String[] configurationFiles, ArtifactDeclaration artifactDeclaration, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInitialisation, boolean disableXmlValidations) throws ConfigurationException {
        this(configurationFiles, artifactProperties, artifactType, enableLazyInitialisation, disableXmlValidations);
        this.artifactDeclaration = artifactDeclaration;
    }

    public static ConfigurationBuilder createConfigurationBuilder(String[] configResources, MuleContext domainContext, boolean enableLazyInitialisation, boolean disableXmlValidations) throws ConfigurationException {
        SpringXmlConfigurationBuilder springXmlConfigurationBuilder = new SpringXmlConfigurationBuilder(configResources, Collections.emptyMap(), ArtifactType.APP, enableLazyInitialisation, disableXmlValidations);
        if (domainContext != null) {
            springXmlConfigurationBuilder.setParentContext(domainContext);
        }
        return springXmlConfigurationBuilder;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.muleArtifactContext = this.createApplicationContext(muleContext);
        this.createSpringRegistry(muleContext, (ApplicationContext)this.muleArtifactContext);
    }

    protected void addResources(List<ConfigResource> allResources) {
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext) throws Exception {
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        if (this.parentContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)this.parentContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        MuleArtifactContext muleArtifactContext = this.doCreateApplicationContext(muleContext, this.artifactDeclaration, applicationObjectcontroller);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        return muleArtifactContext;
    }

    private MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController) {
        if (this.enableLazyInit) {
            return new LazyMuleArtifactContext(muleContext, this.resolveArtifactConfigResources(), artifactDeclaration, optionalObjectsController, this.getArtifactProperties(), this.artifactType, this.resolveArtifactContextPluginClassLoadersRecursively(), this.resolveComponentModelInitializer(), this.resolveParentConfigurationProperties(), this.disableXmlValidations);
        }
        return new MuleArtifactContext(muleContext, this.resolveArtifactConfigResources(), artifactDeclaration, optionalObjectsController, this.getArtifactProperties(), this.artifactType, this.resolveArtifactContextPluginClassLoadersRecursively(), this.resolveParentConfigurationProperties(), this.disableXmlValidations);
    }

    private List<ClassLoader> resolveArtifactContextPluginClassLoadersRecursively() {
        HashSet<ClassLoader> artifactContextPluginClassLoaders = new HashSet<ClassLoader>(MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders());
        artifactContextPluginClassLoaders.addAll(this.resolveArtifactContextPluginClassLoaders(this.parentContext));
        return new ArrayList<ClassLoader>(artifactContextPluginClassLoaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ClassLoader> resolveArtifactContextPluginClassLoaders(ApplicationContext context) {
        HashSet<ClassLoader> artifactContextPluginClassLoaders = new HashSet<ClassLoader>();
        if (context != null) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                artifactContextPluginClassLoaders.addAll(MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders());
                artifactContextPluginClassLoaders.addAll(this.resolveArtifactContextPluginClassLoaders(context.getParent()));
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return artifactContextPluginClassLoaders;
    }

    private ConfigResource[] resolveArtifactConfigResources() {
        return this.artifactConfigResources;
    }

    private Optional<ConfigurationProperties> resolveParentConfigurationProperties() {
        Optional<Object> parentConfigurationProperties = Optional.empty();
        if (this.parentContext != null) {
            parentConfigurationProperties = Optional.of(this.parentContext.getBean(ConfigurationProperties.class));
        }
        return parentConfigurationProperties;
    }

    private Optional<ComponentModelInitializer> resolveComponentModelInitializer() {
        Optional<ComponentModelInitializer> parentLazyComponentInitializer = Optional.empty();
        if (this.parentContext != null && this.parentContext instanceof ComponentModelInitializer) {
            parentLazyComponentInitializer = Optional.of((ComponentModelInitializer)this.parentContext);
        }
        return parentLazyComponentInitializer;
    }

    private void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.parentContext);
        } else {
            this.registry = new SpringRegistry(applicationContext, muleContext, this.muleArtifactContext.getDependencyResolver(), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        }
        ((MuleContextWithRegistries)muleContext).addRegistry((Registry)this.registry);
    }

    private void createRegistryWithParentContext(MuleContext muleContext, ApplicationContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
        }
        ((ConfigurableApplicationContext)applicationContext).setParent(parentContext);
        this.registry = new SpringRegistry(applicationContext, muleContext, this.muleArtifactContext.getDependencyResolver(), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    public ArtifactContext createArtifactContext() {
        return new SpringArtifactContext(this.muleArtifactContext);
    }

    public void setParentContext(MuleContext domainContext) {
        this.parentContext = (ApplicationContext)((MuleContextWithRegistries)domainContext).getRegistry().get("springApplicationContext");
    }
}

