/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.util;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.config.spring.api.XmlGathererErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NoOpXmlErrorHandler
implements XmlGathererErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoOpXmlErrorHandler.class);

    @Override
    public List<SAXParseException> getErrors() {
        return Collections.emptyList();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[WARNING] " + this.getMessage(e), (Throwable)e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[ERROR] " + this.getMessage(e), (Throwable)e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[FATAL] " + this.getMessage(e), (Throwable)e);
        }
    }

    private String getMessage(SAXParseException e) {
        return "while parsing the XML at location [" + e.getLineNumber() + ":" + e.getColumnNumber() + "]";
    }
}

