/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.spring;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.config.spring.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.spring.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

class SimpleTypeBeanDefinitionCreator
extends BeanDefinitionCreator {
    SimpleTypeBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(createBeanDefinitionRequest.getComponentModel());
        createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        Class<?> type = objectTypeVisitor.getType();
        if (DslSimpleType.isSimpleType(type)) {
            SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
            componentModel.setType(type);
            Map<String, String> parameters = componentModel.getParameters();
            if (parameters.size() >= 2) {
                return false;
            }
            if (componentModel.getTextContent() != null && !componentModel.getParameters().isEmpty()) {
                return false;
            }
            String value = componentModel.getTextContent() != null ? componentModel.getTextContent() : parameters.values().iterator().next();
            Optional typeConverterOptional = createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeConverter();
            componentModel.setBeanDefinition(this.getConvertibleBeanDefinition(type, value, typeConverterOptional));
            return true;
        }
        return false;
    }
}

