/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.config.spring.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.internal.LazyComponentInitializer;
import org.mule.runtime.config.spring.internal.LazyConnectivityTestingService;
import org.mule.runtime.config.spring.internal.LazyMetadataService;
import org.mule.runtime.config.spring.internal.LazyValueProviderService;
import org.mule.runtime.config.spring.internal.MuleArtifactContext;
import org.mule.runtime.config.spring.internal.OptionalObjectsController;
import org.mule.runtime.config.spring.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.spring.internal.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializer {
    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ConfigurationProperties> parentConfigurationProperties) throws BeansException {
        super(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, artifactProperties, artifactType, pluginsClassLoaders, parentConfigurationProperties);
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConnectivityTestingService", (Object)new LazyConnectivityTestingService(this, () -> (ConnectivityTestingService)muleContext.getRegistry().get("_muleNonLazyConnectivityTestingService")));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyConnectivityTestingService", DefaultConnectivityTestingService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleMetadataService", (Object)new LazyMetadataService(this, () -> (MetadataService)muleContext.getRegistry().get("_muleNonLazyMetadataService")));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyMetadataService", MuleMetadataService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleValueProviderService", (Object)new LazyValueProviderService(this, () -> (ValueProviderService)muleContext.getRegistry().get("_muleNonLazyValueProviderService")));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyValueProviderService", MuleValueProviderService.class);
    }

    @Override
    protected XmlConfigurationDocumentLoader newXmlConfigurationDocumentLoader() {
        return XmlConfigurationDocumentLoader.noValidationDocumentLoader();
    }

    private void createComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        this.applyLifecycle(super.createApplicationComponents(beanFactory, applicationModel, mustBeRoot));
    }

    private void applyLifecycle(List<String> createdComponentModels) {
        this.muleContext.withLifecycleLock(() -> {
            Object object;
            if (this.muleContext.isInitialised()) {
                for (String createdComponentModelName : createdComponentModels) {
                    object = this.muleContext.getRegistry().get(createdComponentModelName);
                    try {
                        LifecycleUtils.initialiseIfNeeded((Object)object, (boolean)true, (MuleContext)this.muleContext);
                    }
                    catch (InitialisationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (this.muleContext.isStarted()) {
                for (String createdComponentModelName : createdComponentModels) {
                    object = this.muleContext.getRegistry().get(createdComponentModelName);
                    try {
                        LifecycleUtils.startIfNeeded((Object)object);
                    }
                    catch (MuleException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    @Override
    public void initializeComponent(Location location) {
        ClassUtils.withContextClassLoader((ClassLoader)this.muleContext.getExecutionClassLoader(), () -> {
            ConfigurationDependencyResolver dependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry);
            MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(dependencyResolver);
            this.unregisterComponents(dependencyResolver.resolveComponentModelDependencies());
            ApplicationModel minimalApplicationModel = minimalApplicationModelGenerator.getMinimalModel(location);
            this.createComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalApplicationModel, false);
        });
    }

    private void unregisterComponents(List<ComponentModel> componentModels) {
        if (this.muleContext.isStarted()) {
            componentModels.stream().forEach(componentModel -> {
                block3: {
                    String nameAttribute = componentModel.getNameAttribute();
                    if (nameAttribute != null) {
                        try {
                            this.muleContext.getRegistry().unregisterObject(nameAttribute);
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", nameAttribute, e.getMessage()));
                            if (!this.logger.isDebugEnabled()) break block3;
                            this.logger.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
    }
}

