/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.List;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.routing.MessageProcessorExpressionPair;
import org.springframework.beans.factory.FactoryBean;

public class MessageProcessorFilterPairFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<MessageProcessorExpressionPair> {
    private String expression = "true";
    private List<Processor> messageProcessors;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public MessageProcessorExpressionPair getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (Processor processor : this.messageProcessors) {
            if (processor instanceof Processor) {
                builder.chain(new Processor[]{processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessors or MessageProcessorBuilders configured");
        }
        MessageProcessorExpressionPair filterPair = new MessageProcessorExpressionPair(this.expression, (Processor)builder.build());
        filterPair.setAnnotations(this.getAnnotations());
        return filterPair;
    }

    public Class<MessageProcessorExpressionPair> getObjectType() {
        return MessageProcessorExpressionPair.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

