/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.AnnotatedProcessor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;

public class FlowRefFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<Processor>,
ApplicationContextAware,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;

    public void setName(String name) {
        this.refName = name;
    }

    public Processor getObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)"flow reference is empty"));
        }
        return new FlowRefMessageProcessor();
    }

    private Event createChildEvent(Event event) {
        return Event.builder((EventContext)DefaultEventContext.child((EventContext)event.getContext()), (Event)event).build();
    }

    private Event createParentEvent(Event parent, Event result) {
        return Event.builder((EventContext)parent.getContext(), (Event)result).build();
    }

    protected Processor getReferencedFlow(String name, FlowConstruct flowConstruct) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        Processor referencedFlow = (Processor)this.applicationContext.getBean(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (!(referencedFlow instanceof Flow)) {
            if (referencedFlow instanceof AnnotatedObject) {
                ((AnnotatedObject)referencedFlow).setAnnotations(this.getAnnotations());
            }
            if (referencedFlow instanceof Initialisable) {
                this.prepareProcessor(referencedFlow, flowConstruct);
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        this.prepareProcessor(processor, flowConstruct);
                    }
                }
                LifecycleUtils.initialiseIfNeeded((Object)referencedFlow);
            }
            LifecycleUtils.startIfNeeded((Object)referencedFlow);
        }
        return referencedFlow;
    }

    private void prepareProcessor(Processor p, FlowConstruct flowConstruct) {
        if (p instanceof FlowConstructAware) {
            ((FlowConstructAware)p).setFlowConstruct(flowConstruct);
        }
        if (p instanceof MuleContextAware) {
            ((MuleContextAware)p).setMuleContext(this.muleContext);
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return Processor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private class FlowRefMessageProcessor
    implements AnnotatedProcessor,
    FlowConstructAware,
    Stoppable,
    Disposable {
        private FlowConstruct flowConstruct;
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, FlowRefMessageProcessor.this.flowConstruct);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.muleContext.getExpressionManager().isExpression(FlowRefFactoryBean.this.refName);
        }

        public Event process(Event event) throws MuleException {
            try {
                Processor referencedProcessor = this.resolveReferencedProcessor(event);
                if (referencedProcessor instanceof Flow) {
                    return FlowRefFactoryBean.this.createParentEvent(event, ((Processor)event1 -> referencedProcessor.process(event1)).process(FlowRefFactoryBean.this.createChildEvent(event)));
                }
                return referencedProcessor.process(event);
            }
            catch (MessagingException me) {
                me.setProcessedEvent(FlowRefFactoryBean.this.createParentEvent(event, me.getEvent()));
                throw me;
            }
        }

        public Publisher<Event> apply(Publisher<Event> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor referencedProcessor;
                try {
                    referencedProcessor = this.resolveReferencedProcessor((Event)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                if (referencedProcessor instanceof Flow) {
                    Event childEvent = FlowRefFactoryBean.this.createChildEvent(event);
                    Flux.just((Object)childEvent).transform((Function)referencedProcessor).subscribe(null, throwable -> {});
                    return Flux.from((Publisher)childEvent.getContext().getResponsePublisher()).map(result -> Event.builder((EventContext)event.getContext(), (Event)result).build()).doOnError(MessagingException.class, me -> me.setProcessedEvent(FlowRefFactoryBean.this.createParentEvent(event, me.getEvent())));
                }
                return Flux.just((Object)event).transform((Function)referencedProcessor);
            });
        }

        protected Processor resolveReferencedProcessor(Event event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.flowConstruct) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                throw e;
            }
        }

        public Object getAnnotation(QName name) {
            return FlowRefFactoryBean.this.getAnnotation(name);
        }

        public Map<QName, Object> getAnnotations() {
            return FlowRefFactoryBean.this.getAnnotations();
        }

        public void setAnnotations(Map<QName, Object> annotations) {
            FlowRefFactoryBean.this.setAnnotations(annotations);
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstruct = flowConstruct;
        }

        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded((Object)p);
            }
        }

        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded((Object)p, (Logger)LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

