/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.Optional;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.LazyMuleArtifactContext;
import org.mule.runtime.config.spring.dsl.model.NoSuchComponentModelException;

public class LazyMetadataService
implements MetadataService {
    private final LazyMuleArtifactContext lazyMuleArtifactContext;
    private final MetadataService metadataService;

    public LazyMetadataService(LazyMuleArtifactContext lazyMuleArtifactContext, MetadataService metadataService) {
        this.lazyMuleArtifactContext = lazyMuleArtifactContext;
        this.metadataService = metadataService;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getMetadataKeys(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOperationMetadata(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOperationMetadata(location, key));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getSourceMetadata(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getSourceMetadata(location, key));
    }

    public void disposeCache(String id) {
        this.metadataService.disposeCache(id);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getEntityKeys(location));
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getEntityMetadata(location, key));
    }

    private Optional<MetadataResult<?>> initializeComponent(Location location) {
        try {
            this.lazyMuleArtifactContext.initializeComponent(location);
        }
        catch (Exception e) {
            if (ExceptionHelper.getRootException((Throwable)e) instanceof NoSuchComponentModelException) {
                return Optional.of(MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onComponent()}));
            }
            return Optional.of(MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()}));
        }
        return Optional.empty();
    }
}

