/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class SimpleTypeBeanDefinitionCreator
extends BeanDefinitionCreator {
    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(createBeanDefinitionRequest.getComponentModel());
        createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        Class<?> type = objectTypeVisitor.getType();
        if (DslSimpleType.isSimpleType(type)) {
            ComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
            componentModel.setType(type);
            Map<String, String> parameters = componentModel.getParameters();
            Preconditions.checkState((parameters.size() < 2 ? 1 : 0) != 0, (String)"Component model has more than one parameter when it's supposed to have at most one parameter");
            Preconditions.checkState((componentModel.getTextContent() != null || !componentModel.getParameters().isEmpty() ? 1 : 0) != 0, (String)"Component model has both a parameter and an inner content");
            String value = componentModel.getTextContent() != null ? componentModel.getTextContent() : parameters.values().iterator().next();
            Optional typeConverterOptional = createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeConverter();
            componentModel.setBeanDefinition(this.getConvertibleBeanDefinition(type, value, typeConverterOptional));
            return true;
        }
        return false;
    }
}

