/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxy;

public class ReflectionServiceResolver
implements ServiceResolver {
    private final ServiceRegistry serviceRegistry;
    private final Injector containerInjector;
    private final BiFunction<Service, ServiceAssembly, Service> serviceWrapper;

    public ReflectionServiceResolver(ServiceRegistry serviceRegistry, Injector containerInjector, BiFunction<Service, ServiceAssembly, Service> serviceWrapper) {
        this.serviceRegistry = serviceRegistry;
        this.containerInjector = containerInjector;
        this.serviceWrapper = serviceWrapper;
    }

    @Override
    public List<Service> resolveServices(List<ServiceAssembly> assemblies) {
        ArrayList<Service> services = new ArrayList<Service>(assemblies.size());
        for (ServiceAssembly assembly : assemblies) {
            Service service = this.serviceWrapper.apply(LazyServiceProxy.from(assembly, this.serviceRegistry, this.containerInjector), assembly);
            this.serviceRegistry.register(service, assembly.getServiceContract());
            services.add(service);
        }
        return services;
    }
}

