/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.runtime.module.artifact.builder.AbstractDependencyFileBuilder;
import org.mule.tck.ZipUtils;

public class ServiceFileBuilder
extends AbstractArtifactFileBuilder<ServiceFileBuilder> {
    private String serviceProviderClassName;

    public ServiceFileBuilder(String id) {
        super(id);
    }

    public ServiceFileBuilder(ServiceFileBuilder source) {
        super((AbstractArtifactFileBuilder)source);
    }

    protected ServiceFileBuilder getThis() {
        return this;
    }

    public ServiceFileBuilder withServiceProviderClass(String className) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isBlank((String)className) ? 1 : 0) != 0, (Object)"Property value cannot be blank");
        this.serviceProviderClassName = className;
        return this;
    }

    protected final List<ZipUtils.ZipResource> getCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        for (AbstractDependencyFileBuilder dependencyFileBuilder : this.getAllCompileDependencies()) {
            customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactFile().getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFileRepositoryPath()).toString()));
            customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactPomFile().getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFilePomRepositoryPath()).toString()));
        }
        File serviceDescriptor = this.createServiceJsonDescriptorFile();
        customResources.add(new ZipUtils.ZipResource(serviceDescriptor.getAbsolutePath(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION));
        return customResources;
    }

    private File createServiceJsonDescriptorFile() {
        File serviceDescriptor = new File(this.getTempFolder(), this.getArtifactId() + "service.json");
        serviceDescriptor.deleteOnExit();
        MuleServiceModel.MuleServiceModelBuilder serviceModelBuilder = new MuleServiceModel.MuleServiceModelBuilder();
        ((MuleServiceModel.MuleServiceModelBuilder)serviceModelBuilder.setName(this.getArtifactId())).setMinMuleVersion("4.0.0");
        serviceModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        serviceModelBuilder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        serviceModelBuilder.withServiceProviderClassName(this.serviceProviderClassName);
        String serviceDescriptorContent = new MuleServiceModelJsonSerializer().serialize((AbstractMuleArtifactModel)serviceModelBuilder.build());
        try (FileWriter fileWriter = new FileWriter(serviceDescriptor);){
            fileWriter.write(serviceDescriptorContent);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return serviceDescriptor;
    }

    public String getConfigFile() {
        return null;
    }
}

