/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.ServiceDescriptor;
import org.mule.runtime.module.service.ServiceDescriptorFactory;
import org.mule.runtime.module.service.builder.ServiceFileBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class ServiceDescriptorFactoryTestCase
extends AbstractMuleTestCase {
    private static final String SERVICE_NAME = "testService";
    private static final String PROVIDER_CLASS_NAME = "org.foo.FooServiceProvider";
    private DescriptorLoaderRepository descriptorLoaderRepository = (DescriptorLoaderRepository)Mockito.mock(DescriptorLoaderRepository.class);
    private final ServiceDescriptorFactory serviceDescriptorFactory = new ServiceDescriptorFactory(this.descriptorLoaderRepository);
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.descriptorLoaderRepository.get(org.mockito.Matchers.anyString(), (ArtifactType)org.mockito.Matchers.anyObject(), (Class)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo(BundleDescriptorLoader.class)))).thenReturn(Mockito.mock(BundleDescriptorLoader.class));
        Mockito.when((Object)this.descriptorLoaderRepository.get(org.mockito.Matchers.anyString(), (ArtifactType)org.mockito.Matchers.anyObject(), (Class)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo(ClassLoaderModelLoader.class)))).thenReturn(Mockito.mock(ClassLoaderModelLoader.class));
    }

    @Test
    public void createServiceDescriptor() throws Exception {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        MatcherAssert.assertThat((Object)servicesFolder.mkdirs(), (Matcher)Is.is((Object)true));
        ServiceFileBuilder fooService = new ServiceFileBuilder(SERVICE_NAME).withServiceProviderClass(PROVIDER_CLASS_NAME);
        FileUtils.unzip((File)fooService.getArtifactFile(), (File)MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME));
        ServiceDescriptor descriptor = this.serviceDescriptorFactory.create(MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME));
        MatcherAssert.assertThat((Object)descriptor.getName(), (Matcher)Matchers.equalTo((Object)SERVICE_NAME));
        MatcherAssert.assertThat((Object)descriptor.getServiceProviderClassName(), (Matcher)Matchers.equalTo((Object)PROVIDER_CLASS_NAME));
        MatcherAssert.assertThat((Object)descriptor.getRootFolder(), (Matcher)Matchers.equalTo((Object)MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME)));
    }
}

