/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.net.URL;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.service.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.ServiceDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ServiceClassLoaderFactoryTestCase
extends AbstractMuleTestCase {
    private static final String SERVICE_ID = "service/serviceId";
    private final ClassLoaderLookupPolicy lookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    @Rule
    public TemporaryFolder serviceFolder = new TemporaryFolder();
    private ServiceClassLoaderFactory factory = new ServiceClassLoaderFactory();
    private ServiceDescriptor descriptor;

    @Before
    public void setUp() throws Exception {
        this.descriptor = new ServiceDescriptor("testService");
        this.descriptor.setRootFolder(this.serviceFolder.getRoot());
        Mockito.when((Object)this.lookupPolicy.getClassLookupStrategy(Matchers.anyString())).thenReturn((Object)ParentFirstLookupStrategy.PARENT_FIRST);
    }

    @Test
    public void createsEmptyClassLoader() throws Exception {
        ArtifactClassLoader artifactClassLoader = this.factory.create(SERVICE_ID, this.descriptor, ((Object)((Object)this)).getClass().getClassLoader(), this.lookupPolicy);
        MuleArtifactClassLoader classLoader = (MuleArtifactClassLoader)artifactClassLoader.getClassLoader();
        Assert.assertThat((Object)classLoader.getURLs(), (Matcher)IsEqual.equalTo((Object)new URL[0]));
    }

    @Test
    public void usesClassLoaderLookupPolicy() throws Exception {
        ArtifactClassLoader artifactClassLoader = this.factory.create(SERVICE_ID, this.descriptor, ((Object)((Object)this)).getClass().getClassLoader(), this.lookupPolicy);
        MuleArtifactClassLoader classLoader = (MuleArtifactClassLoader)artifactClassLoader.getClassLoader();
        String className = "com.dummy.Foo";
        try {
            classLoader.loadClass("com.dummy.Foo");
            TestCase.fail((String)"Able to load an un-existent class");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ((ClassLoaderLookupPolicy)Mockito.verify((Object)this.lookupPolicy)).getClassLookupStrategy("com.dummy.Foo");
    }
}

