/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.MuleServiceManager;
import org.mule.runtime.module.service.ServiceDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleServiceManagerTestCase
extends AbstractMuleTestCase {
    @Test
    public void registerServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<Pair> services = new ArrayList<Pair>();
        Pair service1 = new Pair(Mockito.mock(ArtifactClassLoader.class), Mockito.mock(Service.class));
        Pair service2 = new Pair(Mockito.mock(ArtifactClassLoader.class), Mockito.mock(Service.class));
        services.add(service1);
        services.add(service2);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        MatcherAssert.assertThat((Object)muleServiceManager.getServices().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat(muleServiceManager.getServices().get(0), (Matcher)Matchers.equalTo((Object)service1.getSecond()));
        MatcherAssert.assertThat(muleServiceManager.getServices().get(1), (Matcher)Matchers.equalTo((Object)service2.getSecond()));
    }

    @Test
    public void startServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<Pair> services = new ArrayList<Pair>();
        Pair service1 = new Pair(Mockito.mock(ArtifactClassLoader.class), Mockito.mock(StartableService.class));
        Pair service2 = new Pair(Mockito.mock(ArtifactClassLoader.class), Mockito.mock(StartableService.class));
        services.add(service1);
        services.add(service2);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{service1.getSecond(), service2.getSecond()});
        ((StartableService)inOrder.verify((Object)((StartableService)service1.getSecond()))).start();
        ((StartableService)inOrder.verify((Object)((StartableService)service2.getSecond()))).start();
    }

    @Test
    public void stopsServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<Pair> services = new ArrayList<Pair>();
        Pair service1Pairs = new Pair(Mockito.mock(ArtifactClassLoader.class), Mockito.mock(StoppableService.class));
        Pair service2Pairs = new Pair(Mockito.mock(ArtifactClassLoader.class), Mockito.mock(StoppableService.class));
        services.add(service1Pairs);
        services.add(service2Pairs);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{service1Pairs.getSecond(), service2Pairs.getSecond()});
        ((StoppableService)inOrder.verify((Object)((StoppableService)service2Pairs.getSecond()))).stop();
        ((StoppableService)inOrder.verify((Object)((StoppableService)service1Pairs.getSecond()))).stop();
    }

    @Test
    public void ignoresServiceStopError() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<Pair> services = new ArrayList<Pair>();
        StoppableService service1 = (StoppableService)Mockito.mock(StoppableService.class);
        ((StoppableService)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)service1)).stop();
        StoppableService service2 = (StoppableService)Mockito.mock(StoppableService.class);
        ((StoppableService)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)service2)).stop();
        services.add(new Pair(Mockito.mock(ArtifactClassLoader.class), (Object)service1));
        services.add(new Pair(Mockito.mock(ArtifactClassLoader.class), (Object)service2));
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{service1, service2});
        ((StoppableService)inOrder.verify((Object)service2)).stop();
        ((StoppableService)inOrder.verify((Object)service1)).stop();
    }

    @Test
    public void wrapsServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<Pair> services = new ArrayList<Pair>();
        StoppableService service1 = (StoppableService)Mockito.mock(StoppableService.class);
        services.add(new Pair(Mockito.mock(ArtifactClassLoader.class), (Object)service1));
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        MatcherAssert.assertThat((Object)Proxy.isProxyClass(((Service)muleServiceManager.getServices().get(0)).getClass()), (Matcher)Is.is((Object)true));
    }

    public static interface StoppableService
    extends Service,
    Stoppable {
    }

    public static interface StartableService
    extends Service,
    Startable {
    }
}

