/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.module.service.LifecycleFilterServiceProxy;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class LifecycleFilterServiceProxyTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void avoidsStartExecution() throws Exception {
        StartableService service = (StartableService)Mockito.mock(StartableService.class);
        Startable serviceProxy = (Startable)LifecycleFilterServiceProxy.createLifecycleFilterServiceProxy((Service)service);
        this.expected.expect(UnsupportedOperationException.class);
        serviceProxy.start();
    }

    @Test
    public void avoidsStopExecution() throws Exception {
        StoppableService service = (StoppableService)Mockito.mock(StoppableService.class);
        Stoppable serviceProxy = (Stoppable)LifecycleFilterServiceProxy.createLifecycleFilterServiceProxy((Service)service);
        this.expected.expect(UnsupportedOperationException.class);
        serviceProxy.stop();
    }

    @Test
    public void checkedExceptionThrownUnwrapped() throws Exception {
        CheckedExceptionService checkExceptionService = (CheckedExceptionService)Mockito.mock(CheckedExceptionService.class);
        DefaultMuleException checkedException = new DefaultMuleException("ERROR");
        ((CheckedExceptionService)Mockito.doThrow((Throwable)checkedException).when((Object)checkExceptionService)).execute();
        CheckedExceptionService checkedExceptionServiceProxy = (CheckedExceptionService)LifecycleFilterServiceProxy.createLifecycleFilterServiceProxy((Service)checkExceptionService);
        this.expected.expect(CoreMatchers.is((Object)checkedException));
        checkedExceptionServiceProxy.execute();
    }

    @Test
    public void uncheckedExceptionThrownUnwrapped() throws Exception {
        UncheckedExceptionService uncheckedExceptionService = (UncheckedExceptionService)Mockito.mock(UncheckedExceptionService.class);
        RuntimeException uncheckedException = new RuntimeException();
        ((UncheckedExceptionService)Mockito.doThrow((Throwable)uncheckedException).when((Object)uncheckedExceptionService)).execute();
        UncheckedExceptionService uncheckedExceptionServiceProxy = (UncheckedExceptionService)LifecycleFilterServiceProxy.createLifecycleFilterServiceProxy((Service)uncheckedExceptionService);
        this.expected.expect(CoreMatchers.is((Object)uncheckedException));
        uncheckedExceptionServiceProxy.execute();
    }

    public static interface UncheckedExceptionService
    extends Service {
        public void execute();
    }

    public static interface CheckedExceptionService
    extends Service {
        public void execute() throws MuleException;
    }

    public static interface StoppableService
    extends Service,
    Stoppable {
    }

    public static interface StartableService
    extends Service,
    Startable {
    }
}

