/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.ServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.reflections.ReflectionUtils;

public class ReflectionServiceProviderResolutionHelper
implements ServiceProviderResolutionHelper {
    @Override
    public void injectInstance(ServiceProvider serviceProvider, Collection<ServiceDefinition> resolvedServices) throws ServiceResolutionError {
        for (Field field : ReflectionUtils.getAllFields(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)})) {
            Class<?> dependencyType = field.getType();
            Object dependency = this.lookupService(resolvedServices, dependencyType);
            if (dependency == null) {
                throw new ServiceResolutionError(String.format("Cannot find a service to inject into field '%s' of service provider '%s'", field.getName(), serviceProvider.getClass().getName()));
            }
            try {
                field.setAccessible(true);
                field.set(serviceProvider, dependency);
            }
            catch (Exception e) {
                throw new ServiceResolutionError(String.format("Could not inject dependency on field %s of type %s", field.getName(), dependencyType.getClass().getName()), e);
            }
        }
    }

    private Object lookupService(Collection<ServiceDefinition> muleServices, Class<?> dependencyType) {
        for (ServiceDefinition muleService : muleServices) {
            if (!muleService.getServiceClass().equals(dependencyType)) continue;
            return muleService.getService();
        }
        return null;
    }

    @Override
    public List<Class<? extends Service>> findServiceDependencies(ServiceProvider serviceProvider) {
        List result = ReflectionUtils.getAllFields(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)}).stream().map(f -> f.getType()).collect(Collectors.toCollection(LinkedList::new));
        result.forEach(clazz -> {
            if (!Service.class.isAssignableFrom((Class<?>)clazz)) {
                throw new IllegalArgumentException("Service providers can depend on Service instances only, but found " + clazz.getName());
            }
        });
        return result;
    }
}

