/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration;

import java.util.HashMap;
import java.util.Map;

public final class HeadersParser {
    private HeadersParser() {
    }

    public static Map<String, String> parseHeaders(String headers) {
        String[] entries;
        if (headers == null) {
            throw new IllegalArgumentException("Headers string cannot be null");
        }
        if (headers.trim().isEmpty()) {
            throw new IllegalArgumentException("Headers configuration has an empty value");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : entries = headers.split(",")) {
            String trimmedEntry = entry.trim();
            if (trimmedEntry.isEmpty()) {
                throw new IllegalArgumentException("Headers configuration contain empty entries");
            }
            int separatorIndex = trimmedEntry.indexOf("=");
            if (separatorIndex == -1) {
                result.put(trimmedEntry, "");
                continue;
            }
            String headerName = trimmedEntry.substring(0, separatorIndex).trim();
            if (headerName.isEmpty()) {
                throw new IllegalArgumentException("Headers configuration contain empty header names");
            }
            String headerValue = trimmedEntry.substring(separatorIndex + 1).trim();
            if (headerValue.isEmpty()) {
                throw new IllegalArgumentException("Headers configuration contain empty header values");
            }
            result.put(headerName, headerValue);
        }
        return result;
    }
}

