/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.Log4JNonBlockingLoggerResolutionClassRegistry;
import org.mule.runtime.module.log4j.internal.RecursiveLoggerContextInstantiationException;

abstract class DispatchingLogger
extends Logger {
    private final Logger originalLogger;
    private final ContextSelector contextSelector;
    private final int ownerClassLoaderHash;
    private final boolean requiresNonBlockingLoggerResolution;
    private final LoadingCache<ClassLoader, Reference<Logger>> loggerCache = Caffeine.newBuilder().weakKeys().weakValues().build(key -> new Reference());

    DispatchingLogger(Logger originalLogger, int ownerClassLoaderHash, LoggerContext loggerContext, ContextSelector contextSelector, MessageFactory messageFactory) {
        super(loggerContext, originalLogger.getName(), messageFactory);
        this.originalLogger = originalLogger;
        this.contextSelector = contextSelector;
        this.ownerClassLoaderHash = ownerClassLoaderHash;
        this.requiresNonBlockingLoggerResolution = Log4JNonBlockingLoggerResolutionClassRegistry.getClassNamesNeedingNonBlockingLoggerResolution().contains(originalLogger.getName());
    }

    private Logger getLogger() {
        return this.getLogger(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getLogger(ClassLoader resolvedCtxClassLoader) {
        Reference loggerReference;
        if (this.useThisLoggerContextClassLoader(resolvedCtxClassLoader)) {
            return this.originalLogger;
        }
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)currentClassLoader, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        try {
            loggerReference = (Reference)this.loggerCache.get((Object)resolvedCtxClassLoader);
        }
        finally {
            ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (ClassLoader)currentClassLoader);
        }
        if (this.requiresNonBlockingLoggerResolution && this.contextSelector instanceof ArtifactAwareContextSelector) {
            return this.getLoggerWithoutBlocking(resolvedCtxClassLoader, (Reference<Logger>)loggerReference);
        }
        return this.getLogger(resolvedCtxClassLoader, (Reference<Logger>)loggerReference);
    }

    private Logger getLoggerWithoutBlocking(ClassLoader resolvedCtxClassLoader, Reference<Logger> loggerReference) {
        Logger logger = (Logger)loggerReference.get();
        if (logger != null) {
            return logger;
        }
        try {
            logger = this.resolveLogger(resolvedCtxClassLoader);
        }
        catch (RecursiveLoggerContextInstantiationException rle) {
            try {
                logger = this.resolveLogger(((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (RecursiveLoggerContextInstantiationException e) {
                return this.originalLogger;
            }
        }
        loggerReference.set((Object)logger);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Logger getLogger(ClassLoader resolvedCtxClassLoader, Reference<Logger> loggerReference) {
        Logger logger = (Logger)loggerReference.get();
        if (logger == null) {
            Reference<Logger> reference = loggerReference;
            synchronized (reference) {
                logger = (Logger)loggerReference.get();
                if (logger == null) {
                    try {
                        logger = this.resolveLogger(resolvedCtxClassLoader);
                    }
                    catch (RecursiveLoggerContextInstantiationException rle) {
                        try {
                            return this.resolveLogger(((Object)((Object)this)).getClass().getClassLoader());
                        }
                        catch (RecursiveLoggerContextInstantiationException e) {
                            return this.originalLogger;
                        }
                    }
                    loggerReference.set((Object)logger);
                }
            }
        }
        return logger;
    }

    private Logger resolveLogger(ClassLoader resolvedCtxClassLoader) {
        Logger logger;
        ContextSelector contextSelector = this.contextSelector;
        if (contextSelector instanceof ArtifactAwareContextSelector) {
            ArtifactAwareContextSelector artifactAwareContextSelector = (ArtifactAwareContextSelector)contextSelector;
            logger = artifactAwareContextSelector.getContextWithResolvedContextClassLoader(resolvedCtxClassLoader).getLogger(this.getName(), this.getMessageFactory());
        } else {
            logger = this.contextSelector.getContext(this.getName(), resolvedCtxClassLoader, true).getLogger(this.getName(), this.getMessageFactory());
        }
        if (logger instanceof DispatchingLogger) {
            return ((DispatchingLogger)logger).getLogger(resolvedCtxClassLoader);
        }
        return logger;
    }

    private boolean useThisLoggerContextClassLoader(ClassLoader currentClassLoader) {
        return currentClassLoader.hashCode() == this.ownerClassLoaderHash;
    }

    public MessageFactory getMessageFactory() {
        return this.originalLogger.getMessageFactory();
    }

    public Logger getParent() {
        return this.getLogger().getParent();
    }

    public LoggerContext getContext() {
        return this.getLogger().getContext();
    }

    public void setLevel(Level level) {
        this.getLogger().setLevel(level);
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        this.getLogger().logMessage(fqcn, level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        return this.getLogger().isEnabled(level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.getLogger().isEnabled(level, marker, message);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.getLogger().isEnabled(level, marker, message, params);
    }

    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.getLogger().isEnabled(level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.getLogger().isEnabled(level, marker, message, t);
    }

    public void addAppender(Appender appender) {
        this.getLogger().addAppender(appender);
    }

    public void removeAppender(Appender appender) {
        this.getLogger().removeAppender(appender);
    }

    public Map<String, Appender> getAppenders() {
        return this.getLogger().getAppenders();
    }

    public Iterator<Filter> getFilters() {
        return this.getLogger().getFilters();
    }

    public Level getLevel() {
        return this.getLogger().getLevel();
    }

    public int filterCount() {
        return this.getLogger().filterCount();
    }

    public void addFilter(Filter filter) {
        this.getLogger().addFilter(filter);
    }

    public boolean isAdditive() {
        return this.getLogger().isAdditive();
    }

    public void setAdditive(boolean additive) {
        this.getLogger().setAdditive(additive);
    }

    public String toString() {
        return this.getLogger().toString();
    }

    public static void checkMessageFactory(ExtendedLogger logger, MessageFactory messageFactory) {
        AbstractLogger.checkMessageFactory((ExtendedLogger)logger, (MessageFactory)messageFactory);
    }

    public void catching(Level level, Throwable t) {
        this.getLogger().catching(level, t);
    }

    public void catching(Throwable t) {
        this.getLogger().catching(t);
    }

    public void debug(Marker marker, Message msg) {
        this.getLogger().debug(marker, msg);
    }

    public void debug(Marker marker, Message msg, Throwable t) {
        this.getLogger().debug(marker, msg, t);
    }

    public void debug(Marker marker, Object message) {
        this.getLogger().debug(marker, message);
    }

    public void debug(Marker marker, Object message, Throwable t) {
        this.getLogger().debug(marker, message, t);
    }

    public void debug(Marker marker, String message) {
        this.getLogger().debug(marker, message);
    }

    public void debug(Marker marker, String message, Object ... params) {
        this.getLogger().debug(marker, message, params);
    }

    public void debug(Marker marker, String message, Throwable t) {
        this.getLogger().debug(marker, message, t);
    }

    public void debug(Message msg) {
        this.getLogger().debug(msg);
    }

    public void debug(Message msg, Throwable t) {
        this.getLogger().debug(msg, t);
    }

    public void debug(Object message) {
        this.getLogger().debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.getLogger().debug(message, t);
    }

    public void debug(String message) {
        this.getLogger().debug(message);
    }

    public void debug(String message, Object ... params) {
        this.getLogger().debug(message, params);
    }

    public void debug(String message, Throwable t) {
        this.getLogger().debug(message, t);
    }

    public void entry() {
        this.getLogger().entry();
    }

    public void entry(Object ... params) {
        this.getLogger().entry(params);
    }

    public void entry(String fqcn, Object ... params) {
        this.getLogger().entry(new Object[]{fqcn, params});
    }

    public void error(Marker marker, Message msg) {
        this.getLogger().error(marker, msg);
    }

    public void error(Marker marker, Message msg, Throwable t) {
        this.getLogger().error(marker, msg, t);
    }

    public void error(Marker marker, Object message) {
        this.getLogger().error(marker, message);
    }

    public void error(Marker marker, Object message, Throwable t) {
        this.getLogger().error(marker, message, t);
    }

    public void error(Marker marker, String message) {
        this.getLogger().error(marker, message);
    }

    public void error(Marker marker, String message, Object ... params) {
        this.getLogger().error(marker, message, params);
    }

    public void error(Marker marker, String message, Throwable t) {
        this.getLogger().error(marker, message, t);
    }

    public void error(Message msg) {
        this.getLogger().error(msg);
    }

    public void error(Message msg, Throwable t) {
        this.getLogger().error(msg, t);
    }

    public void error(Object message) {
        this.getLogger().error(message);
    }

    public void error(Object message, Throwable t) {
        this.getLogger().error(message, t);
    }

    public void error(String message) {
        this.getLogger().error(message);
    }

    public void error(String message, Object ... params) {
        this.getLogger().error(message, params);
    }

    public void error(String message, Throwable t) {
        this.getLogger().error(message, t);
    }

    public void exit() {
        this.getLogger().exit();
    }

    public <R> R exit(R result) {
        return (R)this.getLogger().exit(result);
    }

    public void fatal(Marker marker, Message msg) {
        this.getLogger().fatal(marker, msg);
    }

    public void fatal(Marker marker, Message msg, Throwable t) {
        this.getLogger().fatal(marker, msg, t);
    }

    public void fatal(Marker marker, Object message) {
        this.getLogger().fatal(marker, message);
    }

    public void fatal(Marker marker, Object message, Throwable t) {
        this.getLogger().fatal(marker, message, t);
    }

    public void fatal(Marker marker, String message) {
        this.getLogger().fatal(marker, message);
    }

    public void fatal(Marker marker, String message, Object ... params) {
        this.getLogger().fatal(marker, message, params);
    }

    public void fatal(Marker marker, String message, Throwable t) {
        this.getLogger().fatal(marker, message, t);
    }

    public void fatal(Message msg) {
        this.getLogger().fatal(msg);
    }

    public void fatal(Message msg, Throwable t) {
        this.getLogger().fatal(msg, t);
    }

    public void fatal(Object message) {
        this.getLogger().fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.getLogger().fatal(message, t);
    }

    public void fatal(String message) {
        this.getLogger().fatal(message);
    }

    public void fatal(String message, Object ... params) {
        this.getLogger().fatal(message, params);
    }

    public void fatal(String message, Throwable t) {
        this.getLogger().fatal(message, t);
    }

    public void info(Marker marker, Message msg) {
        this.getLogger().info(marker, msg);
    }

    public void info(Marker marker, Message msg, Throwable t) {
        this.getLogger().info(marker, msg, t);
    }

    public void info(Marker marker, Object message) {
        this.getLogger().info(marker, message);
    }

    public void info(Marker marker, Object message, Throwable t) {
        this.getLogger().info(marker, message, t);
    }

    public void info(Marker marker, String message) {
        this.getLogger().info(marker, message);
    }

    public void info(Marker marker, String message, Object ... params) {
        this.getLogger().info(marker, message, params);
    }

    public void info(Marker marker, String message, Throwable t) {
        this.getLogger().info(marker, message, t);
    }

    public void info(Message msg) {
        this.getLogger().info(msg);
    }

    public void info(Message msg, Throwable t) {
        this.getLogger().info(msg, t);
    }

    public void info(Object message) {
        this.getLogger().info(message);
    }

    public void info(Object message, Throwable t) {
        this.getLogger().info(message, t);
    }

    public void info(String message) {
        this.getLogger().info(message);
    }

    public void info(String message, Object ... params) {
        this.getLogger().info(message, params);
    }

    public void info(String message, Throwable t) {
        this.getLogger().info(message, t);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.getLogger().isDebugEnabled(marker);
    }

    public boolean isEnabled(Level level) {
        return this.getLogger().isEnabled(level);
    }

    public boolean isEnabled(Level level, Marker marker) {
        return this.getLogger().isEnabled(level, marker);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.getLogger().isErrorEnabled(marker);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isFatalEnabled();
    }

    public boolean isFatalEnabled(Marker marker) {
        return this.getLogger().isFatalEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.getLogger().isInfoEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.getLogger().isTraceEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.getLogger().isWarnEnabled(marker);
    }

    public void log(Level level, Marker marker, Message msg) {
        this.getLogger().log(level, marker, msg);
    }

    public void log(Level level, Marker marker, Message msg, Throwable t) {
        this.getLogger().log(level, marker, msg, t);
    }

    public void log(Level level, Marker marker, Object message) {
        this.getLogger().log(level, marker, message);
    }

    public void log(Level level, Marker marker, Object message, Throwable t) {
        this.getLogger().log(level, marker, message, t);
    }

    public void log(Level level, Marker marker, String message) {
        this.getLogger().log(level, marker, message);
    }

    public void log(Level level, Marker marker, String message, Object ... params) {
        this.getLogger().log(level, marker, message, params);
    }

    public void log(Level level, Marker marker, String message, Throwable t) {
        this.getLogger().log(level, marker, message, t);
    }

    public void log(Level level, Message msg) {
        this.getLogger().log(level, msg);
    }

    public void log(Level level, Message msg, Throwable t) {
        this.getLogger().log(level, msg, t);
    }

    public void log(Level level, Object message) {
        this.getLogger().log(level, message);
    }

    public void log(Level level, Object message, Throwable t) {
        this.getLogger().log(level, message, t);
    }

    public void log(Level level, String message) {
        this.getLogger().log(level, message);
    }

    public void log(Level level, String message, Object ... params) {
        this.getLogger().log(level, message, params);
    }

    public void log(Level level, String message, Throwable t) {
        this.getLogger().log(level, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, Message msg, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, msg, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, Object message, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object ... params) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, params);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, MessageSupplier msgSupplier, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, msgSupplier, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, CharSequence message, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, Supplier<?> msgSupplier, Throwable t) {
        this.getLogger().logIfEnabled(fqcn, level, marker, msgSupplier, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, paramSuppliers);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        super.logIfEnabled(fqcn, level, marker, message, p0, p1, p2);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3, p4);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.getLogger().logIfEnabled(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void printf(Level level, Marker marker, String format, Object ... params) {
        this.getLogger().printf(level, marker, format, params);
    }

    public void printf(Level level, String format, Object ... params) {
        this.getLogger().printf(level, format, params);
    }

    public <T extends Throwable> T throwing(T t) {
        return (T)this.getLogger().throwing(t);
    }

    public <T extends Throwable> T throwing(Level level, T t) {
        return (T)this.getLogger().throwing(level, t);
    }

    public void trace(Marker marker, Message msg) {
        this.getLogger().trace(marker, msg);
    }

    public void trace(Marker marker, Message msg, Throwable t) {
        this.getLogger().trace(marker, msg, t);
    }

    public void trace(Marker marker, Object message) {
        this.getLogger().trace(marker, message);
    }

    public void trace(Marker marker, Object message, Throwable t) {
        this.getLogger().trace(marker, message, t);
    }

    public void trace(Marker marker, String message) {
        this.getLogger().trace(marker, message);
    }

    public void trace(Marker marker, String message, Object ... params) {
        this.getLogger().trace(marker, message, params);
    }

    public void trace(Marker marker, String message, Throwable t) {
        this.getLogger().trace(marker, message, t);
    }

    public void trace(Message msg) {
        this.getLogger().trace(msg);
    }

    public void trace(Message msg, Throwable t) {
        this.getLogger().trace(msg, t);
    }

    public void trace(Object message) {
        this.getLogger().trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.getLogger().trace(message, t);
    }

    public void trace(String message) {
        this.getLogger().trace(message);
    }

    public void trace(String message, Object ... params) {
        this.getLogger().trace(message, params);
    }

    public void trace(String message, Throwable t) {
        this.getLogger().trace(message, t);
    }

    public void warn(Marker marker, Message msg) {
        this.getLogger().warn(marker, msg);
    }

    public void warn(Marker marker, Message msg, Throwable t) {
        this.getLogger().warn(marker, msg, t);
    }

    public void warn(Marker marker, Object message) {
        this.getLogger().warn(marker, message);
    }

    public void warn(Marker marker, Object message, Throwable t) {
        this.getLogger().warn(marker, message, t);
    }

    public void warn(Marker marker, String message) {
        this.getLogger().warn(marker, message);
    }

    public void warn(Marker marker, String message, Object ... params) {
        this.getLogger().warn(marker, message, params);
    }

    public void warn(Marker marker, String message, Throwable t) {
        this.getLogger().warn(marker, message, t);
    }

    public void warn(Message msg) {
        this.getLogger().warn(msg);
    }

    public void warn(Message msg, Throwable t) {
        this.getLogger().warn(msg, t);
    }

    public void warn(Object message) {
        this.getLogger().warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.getLogger().warn(message, t);
    }

    public void warn(String message) {
        this.getLogger().warn(message);
    }

    public void warn(String message, Object ... params) {
        this.getLogger().warn(message, params);
    }

    public void warn(String message, Throwable t) {
        this.getLogger().warn(message, t);
    }
}

