/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.license.api;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.internal.DefaultLicenseValidator;

public interface LicenseValidatorProvider {
    public static LicenseValidator discoverLicenseValidator(ClassLoader classLoader) {
        ServiceLoader<LicenseValidator> factories = ServiceLoader.load(LicenseValidator.class, classLoader);
        Iterator<LicenseValidator> iterator = factories.iterator();
        LicenseValidator licenseValidator = null;
        while (iterator.hasNext()) {
            LicenseValidator discoveredLicenseValidator = iterator.next();
            if (licenseValidator != null && discoveredLicenseValidator instanceof DefaultLicenseValidator) continue;
            licenseValidator = discoveredLicenseValidator;
        }
        if (licenseValidator == null) {
            throw new IllegalStateException(String.format("Could not find %s service implementation through SPI", LicenseValidator.class.getName()));
        }
        return licenseValidator;
    }
}

