/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.container.api.MuleCoreExtensionDependency;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.launcher.coreextension.LinkedMuleCoreExtensionDependency;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyDiscoverer;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.UnresolveableDependencyException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ReflectionMuleCoreExtensionDependencyResolverTestCase
extends AbstractMuleTestCase {
    public static final String EXTENSION1 = "extension1";
    public static final String EXTENSION2 = "extension2";
    public static final String DEPENDANT_EXTENSION = "dependantCoreExtension";
    private MuleCoreExtensionDependencyDiscoverer dependencyDiscoverer = (MuleCoreExtensionDependencyDiscoverer)Mockito.mock(MuleCoreExtensionDependencyDiscoverer.class);
    private ReflectionMuleCoreExtensionDependencyResolver dependencyResolver = new ReflectionMuleCoreExtensionDependencyResolver(this.dependencyDiscoverer);

    @Test
    public void resolvesEmptyDependencies() throws Exception {
        List coreExtensions = Collections.EMPTY_LIST;
        this.dependencyResolver.resolveDependencies((Collection)coreExtensions);
        ((MuleCoreExtensionDependencyDiscoverer)Mockito.verify((Object)this.dependencyDiscoverer, (VerificationMode)Mockito.times((int)0))).findDependencies((MuleCoreExtension)Matchers.anyObject());
    }

    @Test
    public void resolvesIndependentExtensions() throws Exception {
        MuleCoreExtension extension1 = this.mockCoreExtension(EXTENSION1);
        MuleCoreExtension extension2 = this.mockCoreExtension(EXTENSION2);
        LinkedList<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
        coreExtensions.add(extension2);
        coreExtensions.add(extension1);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        ((MuleCoreExtensionDependencyDiscoverer)Mockito.verify((Object)this.dependencyDiscoverer, (VerificationMode)Mockito.times((int)2))).findDependencies((MuleCoreExtension)Matchers.anyObject());
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.sameInstance((Object)extension1));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.sameInstance((Object)extension2));
    }

    @Test
    public void resolvesDependentExtensionWhenDependencyIsCreatedFirst() throws Exception {
        TestCoreExtension testCoreExtension = new TestCoreExtension();
        TestCoreExtensionDependency dependantCoreExtension = (TestCoreExtensionDependency)Mockito.mock(TestCoreExtensionDependency.class);
        Mockito.when((Object)dependantCoreExtension.getName()).thenReturn((Object)DEPENDANT_EXTENSION);
        LinkedList<Object> coreExtensions = new LinkedList<Object>();
        coreExtensions.add(testCoreExtension);
        coreExtensions.add(dependantCoreExtension);
        LinkedList<LinkedMuleCoreExtensionDependency> dependencies = new LinkedList<LinkedMuleCoreExtensionDependency>();
        LinkedMuleCoreExtensionDependency linkedMuleCoreExtensionDependency = new LinkedMuleCoreExtensionDependency(TestCoreExtension.class, TestCoreExtensionDependency.class.getMethod("setTestCoreExtension", TestCoreExtension.class));
        dependencies.add(linkedMuleCoreExtensionDependency);
        Mockito.when((Object)this.dependencyDiscoverer.findDependencies((MuleCoreExtension)dependantCoreExtension)).thenReturn(dependencies);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        ((TestCoreExtensionDependency)Mockito.verify((Object)dependantCoreExtension)).setTestCoreExtension(testCoreExtension);
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(TestCoreExtension.class)));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(TestCoreExtensionDependency.class)));
    }

    @Test
    public void resolvesDependentExtensionWhenDependantIsCreatedFirst() throws Exception {
        TestCoreExtension testCoreExtension = new TestCoreExtension();
        TestCoreExtensionDependency dependantCoreExtension = (TestCoreExtensionDependency)Mockito.mock(TestCoreExtensionDependency.class);
        Mockito.when((Object)dependantCoreExtension.getName()).thenReturn((Object)DEPENDANT_EXTENSION);
        LinkedList<Object> coreExtensions = new LinkedList<Object>();
        coreExtensions.add(dependantCoreExtension);
        coreExtensions.add(testCoreExtension);
        LinkedList<LinkedMuleCoreExtensionDependency> dependencies = new LinkedList<LinkedMuleCoreExtensionDependency>();
        LinkedMuleCoreExtensionDependency linkedMuleCoreExtensionDependency = new LinkedMuleCoreExtensionDependency(TestCoreExtension.class, TestCoreExtensionDependency.class.getMethod("setTestCoreExtension", TestCoreExtension.class));
        dependencies.add(linkedMuleCoreExtensionDependency);
        Mockito.when((Object)this.dependencyDiscoverer.findDependencies((MuleCoreExtension)dependantCoreExtension)).thenReturn(dependencies);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        ((TestCoreExtensionDependency)Mockito.verify((Object)dependantCoreExtension)).setTestCoreExtension(testCoreExtension);
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(TestCoreExtension.class)));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(TestCoreExtensionDependency.class)));
    }

    @Test
    public void resolvesCoreExtensionAwareAndStandardExtensions() throws Exception {
        MuleCoreExtension coreExtensionsAwareExtension = this.mockCoreExtension(EXTENSION1);
        TestCoreExtension testCoreExtension = new TestCoreExtension();
        LinkedList<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
        coreExtensions.add(testCoreExtension);
        coreExtensions.add(coreExtensionsAwareExtension);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.sameInstance((Object)testCoreExtension));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.sameInstance((Object)coreExtensionsAwareExtension));
    }

    @Test
    public void resolvesStandardAndCoreExtensionAwareExtensions() throws Exception {
        MuleCoreExtension coreExtensionsAwareExtension = this.mockCoreExtension("coreExtensionsAwareExtension");
        TestCoreExtension testCoreExtension = new TestCoreExtension();
        LinkedList<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
        coreExtensions.add(coreExtensionsAwareExtension);
        coreExtensions.add(testCoreExtension);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.sameInstance((Object)testCoreExtension));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.sameInstance((Object)coreExtensionsAwareExtension));
    }

    @Test
    public void resolvesOrderedCoreExtensionAwareExtensions() throws Exception {
        MuleCoreExtension coreExtensionsAwareExtension1 = this.mockCoreExtension(EXTENSION1);
        MuleCoreExtension coreExtensionsAwareExtension2 = this.mockCoreExtension(EXTENSION2);
        LinkedList<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
        coreExtensions.add(coreExtensionsAwareExtension1);
        coreExtensions.add(coreExtensionsAwareExtension2);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.sameInstance((Object)coreExtensionsAwareExtension1));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.sameInstance((Object)coreExtensionsAwareExtension2));
    }

    @Test
    public void resolvesDisorderedCoreExtensionAwareExtensions() throws Exception {
        MuleCoreExtension coreExtensionsAwareExtension1 = this.mockCoreExtension(EXTENSION1);
        MuleCoreExtension coreExtensionsAwareExtension2 = this.mockCoreExtension(EXTENSION2);
        LinkedList<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
        coreExtensions.add(coreExtensionsAwareExtension2);
        coreExtensions.add(coreExtensionsAwareExtension1);
        List resolvedCoreExtensions = this.dependencyResolver.resolveDependencies(coreExtensions);
        Assert.assertThat((Object)resolvedCoreExtensions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(resolvedCoreExtensions.get(0), (Matcher)CoreMatchers.sameInstance((Object)coreExtensionsAwareExtension1));
        Assert.assertThat(resolvedCoreExtensions.get(1), (Matcher)CoreMatchers.sameInstance((Object)coreExtensionsAwareExtension2));
    }

    @Test(expected=UnresolveableDependencyException.class)
    public void throwsExceptionOnUnresolvedDependency() throws Exception {
        LinkedList<TestCoreExtensionDependency> coreExtensions = new LinkedList<TestCoreExtensionDependency>();
        TestCoreExtensionDependency dependantCoreExtension = (TestCoreExtensionDependency)Mockito.mock(TestCoreExtensionDependency.class);
        coreExtensions.add(dependantCoreExtension);
        LinkedList<LinkedMuleCoreExtensionDependency> dependencies = new LinkedList<LinkedMuleCoreExtensionDependency>();
        LinkedMuleCoreExtensionDependency linkedMuleCoreExtensionDependency = new LinkedMuleCoreExtensionDependency(TestCoreExtension.class, TestCoreExtensionDependency.class.getMethod("setTestCoreExtension", TestCoreExtension.class));
        dependencies.add(linkedMuleCoreExtensionDependency);
        Mockito.when((Object)this.dependencyDiscoverer.findDependencies((MuleCoreExtension)dependantCoreExtension)).thenReturn(dependencies);
        this.dependencyResolver.resolveDependencies(coreExtensions);
    }

    @Test(expected=IllegalDependencyInjectionException.class)
    public void throwsExceptionOnIllegalDependency() throws Exception {
        LinkedList<TestIllegalCoreExtensionDependency> coreExtensions = new LinkedList<TestIllegalCoreExtensionDependency>();
        TestIllegalCoreExtensionDependency dependantCoreExtension = (TestIllegalCoreExtensionDependency)Mockito.mock(TestIllegalCoreExtensionDependency.class);
        coreExtensions.add(dependantCoreExtension);
        LinkedList<LinkedMuleCoreExtensionDependency> dependencies = new LinkedList<LinkedMuleCoreExtensionDependency>();
        LinkedMuleCoreExtensionDependency linkedMuleCoreExtensionDependency = new LinkedMuleCoreExtensionDependency(TestCoreExtension.class, TestCoreExtensionDependency.class.getMethod("setTestCoreExtension", TestCoreExtension.class));
        dependencies.add(linkedMuleCoreExtensionDependency);
        Mockito.when((Object)this.dependencyDiscoverer.findDependencies((MuleCoreExtension)dependantCoreExtension)).thenReturn(dependencies);
        this.dependencyResolver.resolveDependencies(coreExtensions);
    }

    private MuleCoreExtension mockCoreExtension(String extension11) {
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(CoreExtensionsAwareExtension.class);
        Mockito.when((Object)extension1.getName()).thenReturn((Object)extension11);
        return extension1;
    }

    public static interface CoreExtensionsAwareExtension
    extends MuleCoreExtension,
    CoreExtensionsAware {
    }

    public static interface TestIllegalCoreExtensionDependency
    extends MuleCoreExtension,
    CoreExtensionsAware {
        @MuleCoreExtensionDependency
        public void setTestCoreExtension(TestCoreExtension var1);
    }

    public static interface TestCoreExtensionDependency
    extends MuleCoreExtension {
        @MuleCoreExtensionDependency
        public void setTestCoreExtension(TestCoreExtension var1);
    }

    public static class TestCoreExtension
    extends AbstractTestCoreExtension {
        @Override
        public String getName() {
            return "testCoreExtension";
        }
    }

    public static class AbstractTestCoreExtension
    implements MuleCoreExtension {
        public void dispose() {
        }

        public void initialise() throws InitialisationException {
        }

        public String getName() {
            return null;
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }

        public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
        }
    }
}

