/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.functional.logging.TestAppender;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class MuleLoggerContextTestCase
extends AbstractMuleTestCase {
    private static final String DEFAULT_CONTEXT_NAME = "Default";
    private static final String MESSAGE = "Do you wanna build a snowman?";
    private static final String CATEGORY = MuleLoggerContextTestCase.class.getName();
    private static final String TEST_APPENDER = "testAppender";
    private static final Level LEVEL = Level.ERROR;
    @Mock
    private ContextSelector contextSelector;
    @Mock
    private MessageFactory messageFactory;
    private MuleLoggerContext context;
    private TestAppender testAppender;

    @Before
    public void before() {
        this.context = this.getDefaultContext();
        this.testAppender = new TestAppender(TEST_APPENDER, null, null);
        this.context.getConfiguration().addAppender((Appender)this.testAppender);
        LoggerConfig loggerConfig = AsyncLoggerConfig.createLogger((String)"false", (String)LEVEL.name(), (String)CATEGORY, (String)"true", (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)TEST_APPENDER, null, null)}, null, (Configuration)this.context.getConfiguration(), null);
        loggerConfig.addAppender((Appender)this.testAppender, null, null);
        this.context.getConfiguration().addLogger(CATEGORY, loggerConfig);
        this.context.getConfiguration().start();
        this.context.updateLoggers();
    }

    @Test
    public void dispatchingLogger() {
        Assert.assertThat((Object)this.context.newInstance((LoggerContext)this.context, "", this.messageFactory), (Matcher)IsInstanceOf.instanceOf(DispatchingLogger.class));
    }

    @Test
    public void reconfigureAsyncLoggers() {
        Logger logger = this.context.getLogger(CATEGORY);
        logger.error(MESSAGE);
        this.assertLogged();
        this.testAppender.clear();
        this.context.updateLoggers(this.context.getConfiguration());
        logger.error(MESSAGE);
        this.assertLogged();
    }

    private void assertLogged() {
        PollingProber pollingProber = new PollingProber(5000L, 500L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                MuleLoggerContextTestCase.this.testAppender.ensure(new TestAppender.Expectation[]{new TestAppender.Expectation(LEVEL.name(), CATEGORY, MuleLoggerContextTestCase.MESSAGE)});
                return true;
            }

            public String describeFailure() {
                return "message was not logged";
            }
        });
    }

    private MuleLoggerContext getDefaultContext() {
        return new MuleLoggerContext(DEFAULT_CONTEXT_NAME, null, Thread.currentThread().getContextClassLoader(), this.contextSelector, true);
    }
}

