/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.ArtifactClassLoaderManagerAware;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceAware;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleCoreExtensionManagerServer
implements MuleCoreExtensionManagerServer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleCoreExtensionManagerServer.class);
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer;
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver;
    private List<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
    private DeploymentService deploymentService;
    private RepositoryService repositoryService;
    private ToolingService toolingService;
    private List<MuleCoreExtension> orderedCoreExtensions;
    private ArtifactClassLoaderManager artifactClassLoaderManager;

    public DefaultMuleCoreExtensionManagerServer(MuleCoreExtensionDiscoverer coreExtensionDiscoverer, MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver) {
        this.coreExtensionDiscoverer = coreExtensionDiscoverer;
        this.coreExtensionDependencyResolver = coreExtensionDependencyResolver;
    }

    public void dispose() {
        for (MuleCoreExtension extension : this.coreExtensions) {
            try {
                extension.dispose();
            }
            catch (Exception ex) {
                logger.error("Error disposing core extension " + extension.getName(), (Throwable)ex);
            }
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.coreExtensions = this.coreExtensionDiscoverer.discover();
            this.orderedCoreExtensions = this.coreExtensionDependencyResolver.resolveDependencies(this.coreExtensions);
            this.initializeCoreExtensions();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        logger.info("Starting core extensions");
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            extension.start();
        }
    }

    public void stop() throws MuleException {
        if (this.orderedCoreExtensions == null) {
            return;
        }
        for (int i = this.orderedCoreExtensions.size() - 1; i >= 0; --i) {
            MuleCoreExtension extension = this.orderedCoreExtensions.get(i);
            try {
                extension.stop();
                continue;
            }
            catch (Throwable e) {
                logger.warn("Error stopping core extension: " + extension.getName(), e);
            }
        }
    }

    private void initializeCoreExtensions() throws InitialisationException, DefaultMuleException {
        logger.info("Initializing core extensions");
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            if (extension instanceof DeploymentServiceAware) {
                ((DeploymentServiceAware)extension).setDeploymentService(this.deploymentService);
            }
            if (extension instanceof RepositoryServiceAware) {
                ((RepositoryServiceAware)extension).setRepositoryService(this.repositoryService);
            }
            if (extension instanceof ToolingServiceAware) {
                ((ToolingServiceAware)extension).setToolingService(this.toolingService);
            }
            if (extension instanceof DeploymentListener) {
                this.deploymentService.addDeploymentListener((DeploymentListener)extension);
            }
            if (extension instanceof CoreExtensionsAware) {
                ((CoreExtensionsAware)extension).setCoreExtensions(this.orderedCoreExtensions);
            }
            if (extension instanceof ArtifactClassLoaderManagerAware) {
                ((ArtifactClassLoaderManagerAware)extension).setArtifactClassLoaderManager(this.artifactClassLoaderManager);
            }
            extension.initialise();
        }
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    public void setArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.artifactClassLoaderManager = artifactClassLoaderManager;
    }
}

