/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.message;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.support.internal.message.muletosdk.HttpRequestWrapper;
import org.mule.runtime.http.support.internal.message.sdktomule.HttpEntityWrapper;
import org.mule.sdk.api.http.HttpConstants;
import org.mule.sdk.api.http.domain.HttpProtocolVersion;
import org.mule.sdk.api.http.domain.message.request.HttpRequest;

public final class HttpRequestBuilderWrapper
implements org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder {
    private final HttpRequestBuilder builder;

    public HttpRequestBuilderWrapper() {
        this.builder = org.mule.runtime.http.api.domain.message.request.HttpRequest.builder();
    }

    public HttpRequestBuilderWrapper(boolean preserveHeaderCase) {
        this.builder = org.mule.runtime.http.api.domain.message.request.HttpRequest.builder((boolean)preserveHeaderCase);
    }

    public HttpRequestBuilderWrapper(HttpRequestBuilder builder) {
        this.builder = builder;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder uri(String uri) {
        this.builder.uri(uri);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder uri(URI uri) {
        this.builder.uri(uri);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder method(String method) {
        this.builder.method(method);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder method(HttpConstants.Method method) {
        this.builder.method(method.name());
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder protocol(HttpProtocolVersion protocol) {
        this.builder.protocol(HttpProtocol.valueOf((String)protocol.name()));
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder queryParams(MultiMap<String, String> queryParams) {
        this.builder.queryParams(queryParams);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder addQueryParam(String name, String value) {
        this.builder.addQueryParam(name, value);
        return this;
    }

    public URI getUri() {
        return this.builder.getUri();
    }

    public String getMethod() {
        return this.builder.getMethod();
    }

    public MultiMap<String, String> getQueryParams() {
        return this.builder.getQueryParams();
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder entity(org.mule.sdk.api.http.domain.entity.HttpEntity entity) {
        this.builder.entity((HttpEntity)new HttpEntityWrapper(entity));
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder headers(MultiMap<String, String> headersMap) {
        this.builder.headers(headersMap);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder addHeader(String name, String value) {
        this.builder.addHeader(name, value);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder addHeaders(String name, Collection<String> values) {
        this.builder.addHeaders(name, values);
        return this;
    }

    public org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder removeHeader(String name) {
        this.builder.removeHeader(name);
        return this;
    }

    public Optional<String> getHeaderValue(String name) {
        return this.builder.getHeaderValue(name);
    }

    public Collection<String> getHeaderValues(String name) {
        return this.builder.getHeaderValues(name);
    }

    public MultiMap<String, String> getHeaders() {
        return this.builder.getHeaders();
    }

    public HttpRequest build() {
        return new HttpRequestWrapper(this.builder.build());
    }
}

