/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.globalconfig.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.api.model.RepositoryPolicy;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.globalconfig.api.exception.RuntimeGlobalConfigException;

public class MavenConfigBuilder {
    private static final String POSITION = "position";

    public static MavenConfiguration buildMavenConfig(Config mavenConfig) {
        try {
            ConfigObject repositories;
            String globalSettingsLocation = mavenConfig.hasPath("globalSettingsLocation") ? mavenConfig.getString("globalSettingsLocation") : null;
            String userSettingsLocation = mavenConfig.hasPath("userSettingsLocation") ? mavenConfig.getString("userSettingsLocation") : null;
            String settingsSecurityLocation = mavenConfig.hasPath("settingsSecurityLocation") ? mavenConfig.getString("settingsSecurityLocation") : null;
            String repositoryLocation = mavenConfig.hasPath("repositoryLocation") ? mavenConfig.getString("repositoryLocation") : null;
            boolean ignoreArtifactDescriptorRepositories = mavenConfig.hasPath("ignoreArtifactDescriptorRepositories") ? mavenConfig.getBoolean("ignoreArtifactDescriptorRepositories") : true;
            boolean forcePolicyUpdateNever = mavenConfig.hasPath("forcePolicyUpdateNever") ? mavenConfig.getBoolean("forcePolicyUpdateNever") : false;
            boolean offLineMode = mavenConfig.hasPath("offLineMode") ? mavenConfig.getBoolean("offLineMode") : false;
            File globalSettingsFile = MavenConfigBuilder.findResource(globalSettingsLocation);
            File userSettingsFile = MavenConfigBuilder.findResource(userSettingsLocation);
            File settingsSecurityFile = MavenConfigBuilder.findResource(settingsSecurityLocation);
            File repositoryFolder = MavenConfigBuilder.getRuntimeRepositoryFolder();
            if (repositoryLocation != null && !(repositoryFolder = new File(repositoryLocation)).exists()) {
                throw new RuntimeGlobalConfigException(I18nMessageFactory.createStaticMessage((String)String.format("Repository folder %s configured for the mule runtime does not exists", repositoryLocation)));
            }
            MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().localMavenRepositoryLocation(repositoryFolder).ignoreArtifactDescriptorRepositories(ignoreArtifactDescriptorRepositories).forcePolicyUpdateNever(forcePolicyUpdateNever).offlineMode(offLineMode);
            if (globalSettingsFile != null) {
                mavenConfigurationBuilder.globalSettingsLocation(globalSettingsFile);
            }
            if (userSettingsFile != null) {
                mavenConfigurationBuilder.userSettingsLocation(userSettingsFile);
            }
            if (settingsSecurityFile != null) {
                mavenConfigurationBuilder.settingsSecurityLocation(settingsSecurityFile);
            }
            ConfigObject configObject = repositories = mavenConfig.hasPath("repositories") ? mavenConfig.getObject("repositories") : null;
            if (repositories != null) {
                Map repositoriesAsMap = repositories.unwrapped();
                repositoriesAsMap.entrySet().stream().sorted(MavenConfigBuilder.remoteRepositoriesComparator()).forEach(repoEntry -> {
                    String repositoryId = (String)repoEntry.getKey();
                    Map repositoryConfig = (Map)repoEntry.getValue();
                    String url = (String)repositoryConfig.get("url");
                    String username = (String)repositoryConfig.get("username");
                    String password = (String)repositoryConfig.get("password");
                    try {
                        RemoteRepository.RemoteRepositoryBuilder remoteRepositoryBuilder = RemoteRepository.newRemoteRepositoryBuilder().id(repositoryId).url(new URL(url));
                        if (username != null || password != null) {
                            Authentication.AuthenticationBuilder authenticationBuilder = Authentication.newAuthenticationBuilder();
                            if (username != null) {
                                authenticationBuilder.username(username);
                            }
                            if (password != null) {
                                authenticationBuilder.password(password);
                            }
                            MavenConfigBuilder.getRepositoryPolicy(repositoryConfig, "snapshotPolicy").ifPresent(snapshotPolicy -> remoteRepositoryBuilder.snapshotPolicy(snapshotPolicy));
                            MavenConfigBuilder.getRepositoryPolicy(repositoryConfig, "releasePolicy").ifPresent(releasePolicy -> remoteRepositoryBuilder.releasePolicy(releasePolicy));
                            remoteRepositoryBuilder.authentication(authenticationBuilder.build());
                        }
                        mavenConfigurationBuilder.remoteRepository(remoteRepositoryBuilder.build());
                    }
                    catch (MalformedURLException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                });
            }
            return mavenConfigurationBuilder.build();
        }
        catch (Exception e) {
            if (e instanceof RuntimeGlobalConfigException) {
                throw e;
            }
            throw new RuntimeGlobalConfigException(e);
        }
    }

    private static Optional<RepositoryPolicy> getRepositoryPolicy(Map<String, Object> repositoryConfig, String policy) {
        if (repositoryConfig.containsKey(policy)) {
            RepositoryPolicy.RepositoryPolicyBuilder repositoryPolicyBuilder = RepositoryPolicy.newRepositoryPolicyBuilder();
            Map snapshotPolicy = (Map)repositoryConfig.get(policy);
            String enabled = snapshotPolicy.getOrDefault("enabled", null);
            String updatePolicy = snapshotPolicy.getOrDefault("updatePolicy", null);
            String checksumPolicy = snapshotPolicy.getOrDefault("checksumPolicy", null);
            if (enabled != null) {
                repositoryPolicyBuilder.enabled(Boolean.valueOf(enabled).booleanValue());
            }
            if (updatePolicy != null) {
                repositoryPolicyBuilder.updatePolicy(updatePolicy);
            }
            if (checksumPolicy != null) {
                repositoryPolicyBuilder.checksumPolicy(checksumPolicy);
            }
            return Optional.of(repositoryPolicyBuilder.build());
        }
        return Optional.empty();
    }

    private static File findResource(String resourceLocation) {
        URL resource;
        File resourceFile = null;
        if (resourceLocation != null && (resource = MavenConfigBuilder.class.getResource(resourceLocation)) == null && !(resourceFile = new File(resourceLocation)).exists()) {
            throw new RuntimeGlobalConfigException(I18nMessageFactory.createStaticMessage((String)String.format("Couldn't find file %s nor in the classpath or as absolute path", resourceLocation)));
        }
        return resourceFile;
    }

    private static Comparator<Map.Entry<String, Object>> remoteRepositoriesComparator() {
        return (firstEntry, secondEntry) -> {
            Integer firstPosition = Integer.valueOf(((Map)firstEntry.getValue()).getOrDefault(POSITION, String.valueOf(Integer.MAX_VALUE)));
            Integer secondPosition = Integer.valueOf(((Map)secondEntry.getValue()).getOrDefault(POSITION, String.valueOf(Integer.MAX_VALUE)));
            return firstPosition.compareTo(secondPosition);
        };
    }

    private static File getRuntimeRepositoryFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), "repository");
    }

    public static MavenConfiguration buildNullMavenConfig() {
        return MavenConfiguration.newMavenConfigurationBuilder().localMavenRepositoryLocation(MavenConfigBuilder.getRuntimeRepositoryFolder()).build();
    }
}

