/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml.enricher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.internal.ast.property.OperationComponentModelModelProperty;

public class StereotypesDiscoveryDeclarationEnricher
implements DeclarationEnricher {
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassUtils.withContextClassLoader((ClassLoader)extensionLoadingContext.getExtensionClassLoader(), () -> new EnricherDelegate().apply(extensionLoadingContext));
    }

    private static class EnricherDelegate {
        private EnricherDelegate() {
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final Optional modelProperty = extensionDeclaration.getModelProperty(GlobalElementComponentModelModelProperty.class);
            new IdempotentDeclarationWalker(){

                protected void onConfiguration(ConfigurationDeclaration declaration) {
                    this.walkDeclaration(modelProperty, declaration.getAllParameters());
                }

                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    if (owner instanceof ConfigurationDeclaration) {
                        this.walkDeclaration(modelProperty, declaration.getAllParameters());
                    }
                }

                protected void onOperation(OperationDeclaration declaration) {
                    declaration.getModelProperty(OperationComponentModelModelProperty.class).ifPresent(modelProperty -> {
                        ComponentAst bodyComponentModel = modelProperty.getBodyComponentModel();
                        declaration.getAllParameters().stream().filter(parameterDeclaration -> parameterDeclaration.getType() instanceof StringType).forEach(parameterDeclaration -> this.traverseProperty(bodyComponentModel.directChildren(), parameterDeclaration));
                    });
                }
            }.walk(extensionDeclaration);
        }

        private void walkDeclaration(Optional<GlobalElementComponentModelModelProperty> globalElementModelProperty, List<ParameterDeclaration> allParameters) {
            globalElementModelProperty.ifPresent(modelProperty -> allParameters.stream().filter(parameterDeclaration -> parameterDeclaration.getType() instanceof StringType).forEach(parameterDeclaration -> this.traverseProperty((Collection<ComponentAst>)modelProperty.getGlobalElements(), (ParameterDeclaration)parameterDeclaration)));
        }

        private void traverseProperty(Collection<ComponentAst> componentModels, ParameterDeclaration parameterDeclaration) {
            ArrayList allowedStereotypeModels = new ArrayList();
            componentModels.forEach(componentModel -> {
                allowedStereotypeModels.add(this.findStereotypes((ComponentAst)componentModel, parameterDeclaration));
                componentModel.recursiveStream().forEach(innerComponentModel -> allowedStereotypeModels.add(this.findStereotypes((ComponentAst)innerComponentModel, parameterDeclaration)));
            });
            allowedStereotypeModels.stream().filter(stereotypeModels -> !stereotypeModels.isEmpty()).reduce((stereotypeModels, stereotypeModels2) -> {
                ArrayList partialIntersection = new ArrayList(stereotypeModels);
                partialIntersection.retainAll((Collection<?>)stereotypeModels2);
                return partialIntersection;
            }).ifPresent(arg_0 -> ((ParameterDeclaration)parameterDeclaration).setAllowedStereotypeModels(arg_0));
        }

        private List<StereotypeModel> findStereotypes(ComponentAst componentModel, ParameterDeclaration propertyDeclaration) {
            String expectedPropertyReference = "#[vars." + propertyDeclaration.getName() + "]";
            if (!componentModel.getModel(ParameterizedModel.class).isPresent()) {
                return Collections.emptyList();
            }
            return componentModel.getParameters().stream().filter(paramAst -> expectedPropertyReference.equals(paramAst.getResolvedRawValue())).map(paramAst -> paramAst.getModel().getName()).map(attributeName -> this.findStereotypes(componentModel, (String)attributeName)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private List<StereotypeModel> findStereotypes(ComponentAst componentModel, String attributeName) {
            return componentModel.getModel(ParameterizedModel.class).flatMap(pmzd -> pmzd.getAllParameterModels().stream().filter(pm -> pm.getName().equals(attributeName)).findAny()).map(pm -> pm.getAllowedStereotypes()).orElse(Collections.emptyList());
        }
    }
}

