/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.catalog.builder;

import com.google.common.base.Throwables;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.extension.internal.loader.catalog.builder.TypesResolverBuilder;
import org.mule.runtime.extension.internal.loader.catalog.model.TypesCatalog;

public class TypesCatalogBuilder {
    private final List<TypesResolverBuilder> typesResolverBuilders;
    private URI baseUri;

    public TypesCatalogBuilder(URI baseUri) {
        this.baseUri = baseUri;
        this.typesResolverBuilders = new ArrayList<TypesResolverBuilder>();
    }

    public void addTypesResolver(Consumer<TypesResolverBuilder> typesResolverBuilderConsumer) {
        TypesResolverBuilder typesResolverBuilder = new TypesResolverBuilder(this.baseUri);
        typesResolverBuilderConsumer.accept(typesResolverBuilder);
        this.typesResolverBuilders.add(typesResolverBuilder);
    }

    public TypesCatalog build() throws Exception {
        return new TypesCatalog(this.typesResolverBuilders.stream().map(typesResolverBuilder -> {
            try {
                return typesResolverBuilder.build();
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }).collect(Collectors.toList()));
    }
}

