/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.UnauthorizeOperationExecutor;

public class JavaOAuthDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static final DefaultStringType stringType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    private static final VoidType voidType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build();

    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){
            private final ExtensionDeclaration extensionDeclaration;
            private final Set<Reference<ConfigurationDeclaration>> oauthConfigs;
            private boolean oauthGloballySupported;
            private boolean supportsAuthCode;
            {
                this.extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
                this.oauthConfigs = new HashSet<Reference<ConfigurationDeclaration>>();
                this.oauthGloballySupported = false;
                this.supportsAuthCode = false;
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                declaration.getModelProperty(OAuthModelProperty.class).ifPresent(mp -> {
                    mp.getGrantTypes().forEach(grantType -> grantType.accept(new OAuthGrantTypeVisitor(){

                        public void visit(AuthorizationCodeGrantType grantType) {
                            supportsAuthCode = true;
                        }

                        public void visit(ClientCredentialsGrantType grantType) {
                        }

                        public void visit(PlatformManagedOAuthGrantType grantType) {
                        }
                    }));
                    if (owner instanceof ExtensionDeclaration) {
                        this.oauthGloballySupported = true;
                    } else if (owner instanceof ConfigurationDeclaration) {
                        this.oauthConfigs.add((Reference<ConfigurationDeclaration>)new Reference((Object)((ConfigurationDeclaration)owner)));
                    }
                });
            }

            public void onWalkFinished() {
                List<ConfigurationDeclaration> configs = this.oauthGloballySupported ? this.extensionDeclaration.getConfigurations() : this.oauthConfigs.stream().map(Reference::get).collect(Collectors.toList());
                if (!configs.isEmpty()) {
                    OperationDeclaration unauthorize = this.buildUnauthorizeOperation(this.supportsAuthCode);
                    configs.forEach(c -> c.addOperation(unauthorize));
                }
            }

            private OperationDeclaration buildUnauthorizeOperation(boolean supportsAuthCode) {
                OperationDeclaration operation = new OperationDeclaration("unauthorize");
                operation.setDescription("Deletes all the access token information of a given resource owner id so that it's impossible to execute any operation for that user without doing the authorization dance again");
                operation.setBlocking(true);
                operation.setExecutionType(ExecutionType.BLOCKING);
                operation.setOutput(this.toDeclaration((MetadataType)voidType));
                operation.setOutputAttributes(this.toDeclaration((MetadataType)voidType));
                operation.setRequiresConnection(false);
                operation.setSupportsStreaming(false);
                operation.setTransactional(false);
                operation.addModelProperty((ModelProperty)new CompletableComponentExecutorModelProperty((model, params) -> new UnauthorizeOperationExecutor()));
                if (supportsAuthCode) {
                    ParameterGroupDeclaration group = operation.getParameterGroup("General");
                    group.showInDsl(false);
                    ParameterDeclaration parameter = new ParameterDeclaration("resourceOwnerId");
                    parameter.setDescription("The id of the resource owner which access should be invalidated");
                    parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
                    parameter.setLayoutModel(LayoutModel.builder().build());
                    parameter.setRequired(false);
                    parameter.setParameterRole(ParameterRole.BEHAVIOUR);
                    parameter.setType((MetadataType)stringType, false);
                    group.addParameter(parameter);
                }
                return operation;
            }

            private OutputDeclaration toDeclaration(MetadataType type) {
                OutputDeclaration declaration = new OutputDeclaration();
                declaration.setType(type, false);
                return declaration;
            }
        });
    }
}

