/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.List;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.api.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.OutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.JavaConnectionProviderModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaModelLoaderUtils;
import org.mule.sdk.api.annotation.param.Connection;

abstract class AbstractJavaExecutableComponentModelParser
extends AbstractJavaModelParser {
    protected OutputModelParser outputType;
    protected OutputModelParser outputAttributesType;
    protected boolean supportsStreaming = false;
    protected boolean connected = false;
    protected boolean transactional = false;

    public AbstractJavaExecutableComponentModelParser(ExtensionElement extensionElement, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
    }

    protected abstract String getComponentTypeName();

    protected abstract String getName();

    protected void parseComponentConnectivity(WithParameters component) {
        List<ExtensionParameter> connectionParameters = component.getParametersAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Connection.class);
        if (connectionParameters.isEmpty()) {
            connectionParameters = component.getParametersAnnotatedWith(Connection.class);
        }
        if (connectionParameters.isEmpty()) {
            this.connected = false;
            this.transactional = false;
        } else if (connectionParameters.size() == 1) {
            this.connected = true;
            ExtensionParameter connectionParameter = connectionParameters.iterator().next();
            Type connectionType = this.resolveConnectionType(connectionParameter);
            this.transactional = JavaConnectionProviderModelParserUtils.isTransactional(connectionType);
            this.additionalModelProperties.add(new ConnectivityModelProperty(connectionType));
        } else {
            throw new IllegalOperationModelDefinitionException(String.format("%s '%s' defines %d parameters annotated with @%s. Only one is allowed", this.getComponentTypeName(), this.getName(), connectionParameters.size(), org.mule.runtime.extension.api.annotation.param.Connection.class.getSimpleName()));
        }
    }

    protected void parseComponentByteStreaming(WithAnnotations element) {
        this.supportsStreaming = JavaModelLoaderUtils.isInputStream(this.outputType.getType()) || element.isAnnotatedWith(Streaming.class) || element.isAnnotatedWith(org.mule.sdk.api.annotation.Streaming.class);
    }

    private Type resolveConnectionType(ExtensionParameter connectionParameter) {
        Type connectionType = connectionParameter.getType();
        if (connectionType.getTypeName().startsWith(ConnectionProvider.class.getName()) || connectionType.getTypeName().startsWith(org.mule.sdk.api.connectivity.ConnectionProvider.class.getName())) {
            List<TypeGeneric> generics = connectionType.getGenerics();
            if (generics.size() == 0) {
                throw new IllegalOperationModelDefinitionException(String.format("%s '%s' defines a %s without a connection type. Please add the generic", this.getComponentTypeName(), this.getName(), ConnectionProvider.class.getSimpleName()));
            }
            return generics.get(0).getConcreteType();
        }
        return connectionType;
    }

    public OutputModelParser getOutputType() {
        return this.outputType;
    }

    public OutputModelParser getAttributesOutputType() {
        return this.outputAttributesType;
    }

    public boolean supportsStreaming() {
        return this.supportsStreaming;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isTransactional() {
        return this.transactional;
    }
}

