/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.documentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.internal.resources.documentation.DefaultXmlExtensionDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.DefaultXmlExtensionElementDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.DefaultXmlExtensionParameterDocumentation;

public class ExtensionDocumentationResourceGenerator
implements GeneratedResourceFactory {
    private static final String META_INF_RESOURCE_PREFIX = "META-INF/";

    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        ExtensionDocumenterWalker walker = new ExtensionDocumenterWalker();
        walker.walk(extensionModel);
        String documenter = ExtensionDescriptionsSerializer.SERIALIZER.serialize(this.getDocumenter(extensionModel, walker.getConfigs(), walker.getConnections(), walker.getOperations(), walker.getSources(), this.getTypesDocumentation(extensionModel)));
        return Optional.of(new GeneratedResource(true, META_INF_RESOURCE_PREFIX + ExtensionDescriptionsSerializer.SERIALIZER.getFileName(extensionModel.getName()), documenter.getBytes()));
    }

    private List<DefaultXmlExtensionElementDocumentation> getTypesDocumentation(ExtensionModel extensionModel) {
        return extensionModel.getTypes().stream().map(type -> ExtensionMetadataTypeUtils.getId((MetadataType)type).map(id -> {
            DefaultXmlExtensionElementDocumentation element = new DefaultXmlExtensionElementDocumentation();
            element.setName((String)id);
            element.setDescription(this.getDescription((MetadataType)type));
            element.setParameters(type.getFields().stream().map(f -> new DefaultXmlExtensionParameterDocumentation(ExtensionMetadataTypeUtils.getAlias((ObjectFieldType)f), this.getDescription((MetadataType)f))).toList());
            return element;
        })).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private String getDescription(MetadataType type) {
        return type.getAnnotation(DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse("");
    }

    private DefaultXmlExtensionDocumentation getDocumenter(ExtensionModel model, List<DefaultXmlExtensionElementDocumentation> configs, List<DefaultXmlExtensionElementDocumentation> connections, List<DefaultXmlExtensionElementDocumentation> operations, List<DefaultXmlExtensionElementDocumentation> sources, List<DefaultXmlExtensionElementDocumentation> types) {
        DefaultXmlExtensionDocumentation documenter = new DefaultXmlExtensionDocumentation();
        DefaultXmlExtensionElementDocumentation element = new DefaultXmlExtensionElementDocumentation();
        element.setName(model.getName());
        element.setDescription(model.getDescription());
        element.setParameters(Collections.emptyList());
        documenter.setExtension(element);
        documenter.setConfigs(configs);
        documenter.setConnections(connections);
        documenter.setOperation(operations);
        documenter.setSources(sources);
        documenter.setTypes(types);
        return documenter;
    }

    private class ExtensionDocumenterWalker
    extends ExtensionWalker {
        List<DefaultXmlExtensionElementDocumentation> configs = new ArrayList<DefaultXmlExtensionElementDocumentation>();
        List<DefaultXmlExtensionElementDocumentation> connections = new ArrayList<DefaultXmlExtensionElementDocumentation>();
        List<DefaultXmlExtensionElementDocumentation> operations = new ArrayList<DefaultXmlExtensionElementDocumentation>();
        List<DefaultXmlExtensionElementDocumentation> sources = new ArrayList<DefaultXmlExtensionElementDocumentation>();

        private ExtensionDocumenterWalker() {
        }

        protected void onConfiguration(ConfigurationModel model) {
            this.configs.add(this.createParameterizedElement((ParameterizedModel)model));
        }

        protected void onOperation(HasOperationModels owner, OperationModel model) {
            this.operations.add(this.createParameterizedElement((ParameterizedModel)model));
        }

        protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
            this.connections.add(this.createParameterizedElement((ParameterizedModel)model));
        }

        protected void onSource(HasSourceModels owner, SourceModel model) {
            this.sources.add(this.createParameterizedElement((ParameterizedModel)model));
        }

        private DefaultXmlExtensionElementDocumentation createParameterizedElement(ParameterizedModel model) {
            DefaultXmlExtensionElementDocumentation element = new DefaultXmlExtensionElementDocumentation();
            element.setName(model.getName());
            element.setDescription(model.getDescription());
            element.setParameters(model.getAllParameterModels().stream().map(p -> new DefaultXmlExtensionParameterDocumentation(p.getName(), p.getDescription())).toList());
            return element;
        }

        public List<DefaultXmlExtensionElementDocumentation> getConfigs() {
            return this.configs;
        }

        public List<DefaultXmlExtensionElementDocumentation> getConnections() {
            return this.connections;
        }

        public List<DefaultXmlExtensionElementDocumentation> getOperations() {
            return this.operations;
        }

        public List<DefaultXmlExtensionElementDocumentation> getSources() {
            return this.sources;
        }
    }
}

