/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.Optional;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaModelValidationUtils;

public class PojosModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        if (!JavaModelValidationUtils.isCompiletime(extensionModel)) {
            return;
        }
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                PojosModelValidator.this.validateOverridesEqualsAndHashCode((ParameterizedModel)model, problemsReporter);
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                PojosModelValidator.this.validateOverridesEqualsAndHashCode((ParameterizedModel)model, problemsReporter);
            }

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Optional modelProperty = model.getModelProperty(ExtensionParameterDescriptorModelProperty.class);
                if (modelProperty.isPresent()) {
                    ClassInformationAnnotation classInformationAnnotation;
                    Type type = ((ExtensionParameterDescriptorModelProperty)modelProperty.get()).getExtensionParameter().getType();
                    if (type.isSameType(TypedValue.class)) {
                        type = PojosModelValidator.this.getFirstGenericType(type).orElse(null);
                    }
                    if (type != null && type.asMetadataType() instanceof ObjectType && !(classInformationAnnotation = type.getClassInformation()).isAbstract() && !classInformationAnnotation.isInterface() && !classInformationAnnotation.hasDefaultConstructor()) {
                        problemsReporter.addError(new Problem((NamedObject)model, String.format("Type '%s' does not have a default constructor", type.getName())));
                    }
                }
            }
        }.walk(extensionModel);
    }

    private void validateOverridesEqualsAndHashCode(ParameterizedModel model, ProblemsReporter reporter) {
        model.getAllParameterModels().forEach(parameterModel -> {
            Type type;
            ClassInformationAnnotation classInformationAnnotation;
            Optional modelProperty = parameterModel.getModelProperty(ExtensionParameterDescriptorModelProperty.class);
            if (modelProperty.isPresent() && !(classInformationAnnotation = (type = ((ExtensionParameterDescriptorModelProperty)modelProperty.get()).getExtensionParameter().getType()).getClassInformation()).isInterface() && !classInformationAnnotation.isAbstract() && type.asMetadataType() instanceof ObjectType) {
                Optional<MethodElement> equals = type.getMethod("equals", Object.class);
                Optional<MethodElement> hashCode = type.getMethod("hashCode", new Class[0]);
                if (!equals.isPresent() || !hashCode.isPresent()) {
                    reporter.addError(new Problem((NamedObject)model, String.format("Type '%s' must override equals and hashCode", type.getName())));
                }
            }
        });
    }

    private Optional<Type> getFirstGenericType(Type typeWithGenerics) {
        return typeWithGenerics.getGenerics().stream().findFirst().map(TypeGeneric::getConcreteType);
    }
}

