/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.operation;

import java.util.HashMap;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.client.NullComponent;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationKey;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

abstract class ComponentExecutorResolver {
    ComponentExecutorResolver() {
    }

    static CompletableComponentExecutor<OperationModel> from(OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache) {
        OperationModel operationModel = key.getOperationModel();
        CompletableComponentExecutorFactory<OperationModel> operationExecutorFactory = MuleExtensionUtils.getOperationExecutorFactory(operationModel);
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        try {
            initParams.putAll(CompletableOperationExecutorFactory.extractExecutorInitialisationParams(key.getExtensionModel(), (ComponentModel)operationModel, initParams, NullComponent.NULL_COMPONENT, Optional.empty(), extensionManager, expressionManager, reflectionCache));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception found resolving parameters for operation client: " + e.getMessage())), (Throwable)e);
        }
        return operationExecutorFactory.createExecutor((ComponentModel)operationModel, initParams);
    }
}

