/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.VariableElement;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ParameterElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureTypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.springframework.core.ResolvableType;

public final class ParameterWrapper
implements ParameterElement {
    private final Parameter parameter;
    private final Method owner;
    private final int index;
    private final ClassTypeLoader typeLoader;

    public ParameterWrapper(Method owner, int index, ClassTypeLoader typeLoader) {
        this.index = index;
        this.typeLoader = typeLoader;
        this.parameter = owner.getParameters()[index];
        this.owner = owner;
    }

    @Override
    public Optional<Parameter> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    @Override
    public TypeWrapper getType() {
        return new ParameterTypeWrapper(ResolvableType.forMethodParameter(this.owner, this.index), this.typeLoader);
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.parameter.getAnnotation(annotationClass));
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.parameter.getAnnotation(annotation) != null;
    }

    @Override
    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher<A>(annotationClass, this.parameter, this.typeLoader)) : Optional.empty();
    }

    @Override
    public Stream<Type> getAnnotations() {
        return Arrays.stream(this.parameter.getAnnotations()).map(ann -> new TypeWrapper(ann.annotationType(), this.typeLoader));
    }

    @Override
    public String getAlias() {
        return InfrastructureTypeResolver.getInfrastructureType(this.getType()).map(InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType::getName).orElse(ParameterElement.super.getAlias());
    }

    @Override
    public String getName() {
        return this.parameter.getName();
    }

    @Override
    public String getOwnerDescription() {
        return String.format("Method: '%s'", this.owner.getName());
    }

    @Override
    public Optional<VariableElement> getElement() {
        return Optional.empty();
    }
}

