/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.param.NullSafe;
import org.mule.sdk.api.meta.Category;

public final class JavaParserUtils {
    private JavaParserUtils() {
    }

    public static String getAlias(Field field) {
        return JavaParserUtils.getAlias(field, field::getName);
    }

    public static String getAlias(Class<?> clazz) {
        return JavaParserUtils.getAlias(clazz, clazz::getSimpleName);
    }

    public static String getAlias(AnnotatedElement element, Supplier<String> defaultValue) {
        return JavaParserUtils.getAlias(element::getAnnotation, defaultValue);
    }

    public static String getAlias(Function<Class<? extends Annotation>, Annotation> annotationMapper, Supplier<String> defaultValue) {
        String name = null;
        Alias legacyAlias = (Alias)annotationMapper.apply(Alias.class);
        if (legacyAlias != null) {
            name = legacyAlias.value();
        } else {
            org.mule.sdk.api.annotation.Alias alias = (org.mule.sdk.api.annotation.Alias)annotationMapper.apply(org.mule.sdk.api.annotation.Alias.class);
            if (alias != null) {
                name = alias.value();
            }
        }
        return name == null || name.length() == 0 ? defaultValue.get() : name;
    }

    public static Optional<ExpressionSupport> getExpressionSupport(AnnotatedElement element) {
        return JavaParserUtils.getExpressionSupport(element::getAnnotation);
    }

    public static Optional<ExpressionSupport> getExpressionSupport(Function<Class<? extends Annotation>, ? extends Annotation> mapper) {
        return JavaParserUtils.mapReduceAnnotation(mapper, org.mule.runtime.extension.api.annotation.Expression.class, Expression.class, (R ann) -> ann.value(), (S ann) -> JavaParserUtils.toMuleApi(ann.value()));
    }

    public static boolean isConfigOverride(Field field) {
        ConfigOverride legacyOverride = field.getAnnotation(ConfigOverride.class);
        org.mule.sdk.api.annotation.param.ConfigOverride sdkOverride = field.getAnnotation(org.mule.sdk.api.annotation.param.ConfigOverride.class);
        return legacyOverride != null || sdkOverride != null;
    }

    public static Optional<Class<?>> getNullSafeDefaultImplementedType(Field field) {
        return JavaParserUtils.mapReduceAnnotation(field::getAnnotation, org.mule.runtime.extension.api.annotation.param.NullSafe.class, NullSafe.class, org.mule.runtime.extension.api.annotation.param.NullSafe::defaultImplementingType, NullSafe::defaultImplementingType);
    }

    public static <R extends Annotation, S extends Annotation, T> Optional<T> mapReduceAnnotation(Element element, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass, Function<R, T> legacyAnnotationMapping, Function<S, T> sdkAnnotationMapping) {
        return JavaParserUtils.mapReduceAnnotation(element::getAnnotation, legacyAnnotationClass, sdkAnnotationClass, legacyAnnotationMapping, sdkAnnotationMapping);
    }

    public static ExpressionSupport toMuleApi(org.mule.sdk.api.meta.ExpressionSupport support) {
        if (support == org.mule.sdk.api.meta.ExpressionSupport.SUPPORTED) {
            return ExpressionSupport.SUPPORTED;
        }
        if (support == org.mule.sdk.api.meta.ExpressionSupport.NOT_SUPPORTED) {
            return ExpressionSupport.NOT_SUPPORTED;
        }
        if (support == org.mule.sdk.api.meta.ExpressionSupport.REQUIRED) {
            return ExpressionSupport.REQUIRED;
        }
        throw new IllegalModelDefinitionException("Unsupported expression support type " + support);
    }

    public static org.mule.runtime.api.meta.Category toMuleApi(Category category) {
        if (category == Category.SELECT) {
            return org.mule.runtime.api.meta.Category.SELECT;
        }
        if (category == Category.COMMUNITY) {
            return org.mule.runtime.api.meta.Category.COMMUNITY;
        }
        if (category == Category.CERTIFIED) {
            return org.mule.runtime.api.meta.Category.CERTIFIED;
        }
        if (category == Category.PREMIUM) {
            return org.mule.runtime.api.meta.Category.PREMIUM;
        }
        throw new IllegalModelDefinitionException("Unsupported Category type " + category);
    }

    private static <R extends Annotation, S extends Annotation, T> Optional<T> mapReduceAnnotation(Function<Class<? extends Annotation>, ? extends Annotation> mapper, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass, Function<R, T> legacyAnnotationMapping, Function<S, T> sdkAnnotationMapping) {
        Annotation legacyAnnotation = mapper.apply(legacyAnnotationClass);
        Annotation sdkAnnotation = mapper.apply(sdkAnnotationClass);
        Optional result = legacyAnnotation != null ? Optional.ofNullable(legacyAnnotationMapping.apply(legacyAnnotation)) : (sdkAnnotation != null ? Optional.ofNullable(sdkAnnotationMapping.apply(sdkAnnotation)) : Optional.empty());
        return result;
    }
}

