/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.EventedResult;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class ChainExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainExecutor.class);
    private final CoreEvent originalEvent;
    private final MessageProcessorChain chain;

    ChainExecutor(MessageProcessorChain chain, CoreEvent originalEvent) {
        this.chain = chain;
        this.originalEvent = originalEvent;
    }

    public void execute(CoreEvent event, Consumer<Result> successHandler, BiConsumer<Throwable, Result> errorHandler) {
        SdkInternalContext sdkInternalCtx = SdkInternalContext.from(event);
        Function<Object, Object> innerChainCtxMapping = Function.identity();
        if (sdkInternalCtx != null) {
            innerChainCtxMapping = sdkInternalCtx.getInnerChainSubscriberContextMapping();
        }
        Mono.from((Publisher)MessageProcessors.processWithChildContextDontComplete((CoreEvent)event, (ReactiveProcessor)this.chain, Optional.ofNullable(this.chain.getLocation()))).doOnSuccess(childEvent -> this.handleSuccess((CoreEvent)childEvent, successHandler, errorHandler)).doOnError(error -> {
            if (error instanceof MessagingException) {
                this.handleError((Throwable)error, ((MessagingException)error).getEvent(), errorHandler);
            } else {
                LOGGER.error("Exception in nested chain", error);
                this.handleError((Throwable)error, event, errorHandler);
            }
        }).contextWrite(innerChainCtxMapping).subscribe();
    }

    private void handleSuccess(CoreEvent childEvent, Consumer<Result> successHandler, BiConsumer<Throwable, Result> errorHandler) {
        EventedResult result = childEvent != null ? EventedResult.from((CoreEvent)childEvent) : Result.builder().build();
        try {
            successHandler.accept((Result)result);
        }
        catch (Throwable error) {
            errorHandler.accept(error, (Result)result);
        }
    }

    private CoreEvent handleError(Throwable error, CoreEvent childEvent, BiConsumer<Throwable, Result> errorHandler) {
        try {
            errorHandler.accept(error, (Result)EventedResult.from((CoreEvent)childEvent));
        }
        catch (Throwable e) {
            ((BaseEventContext)this.originalEvent.getContext()).error(e);
        }
        return null;
    }
}

