/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.extension.internal.runtime.resolver.LifecycleAwareValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class RequiredParameterValueResolverWrapper<T>
extends LifecycleAwareValueResolverWrapper<T> {
    @Inject
    private ConfigurationProperties properties;
    private final String errorMessage;

    public RequiredParameterValueResolverWrapper(ValueResolver<T> delegate, String parameterName, String literalValue) {
        super(delegate);
        this.errorMessage = String.format("Required parameter '%s' was assigned with value '%s' which resolved to null. Required parameters need to be assigned with non null values", parameterName, literalValue);
    }

    public RequiredParameterValueResolverWrapper(ValueResolver<T> delegate, String parameterName) {
        super(delegate);
        this.errorMessage = String.format("Required parameter '%s' resolved to null. Required parameters need to be assigned with non null values", parameterName);
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        Object value = super.resolve(context);
        if (value == null) {
            throw new IllegalArgumentException(this.errorMessage);
        }
        return value;
    }
}

