/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.internal.util.ExtensionConnectivityUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionInterceptor;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.tracer.api.component.ComponentTracer;

public class InterceptorChainUtils {
    private InterceptorChainUtils() {
    }

    public static InterceptorChain createConnectionInterceptorsChain(ExtensionModel extensionModel, ComponentModel componentModel, ExtensionConnectionSupplier connectionSupplier, ReflectionCache reflectionCache, ComponentTracer<CoreEvent> connectionComponentTracer) {
        InterceptorChain.Builder chainBuilder = InterceptorChain.builder();
        if (InterceptorChainUtils.requiresConnectionInterceptors(extensionModel, componentModel)) {
            InterceptorChainUtils.addConnectionInterceptors(chainBuilder, connectionSupplier, connectionComponentTracer);
        }
        ReconnectionUtils.addCursorResetInterceptorsIfRequired(chainBuilder, extensionModel, componentModel, reflectionCache);
        return chainBuilder.build();
    }

    private static boolean requiresConnectionInterceptors(ExtensionModel extensionModel, ComponentModel componentModel) {
        if (componentModel instanceof ConnectableComponentModel) {
            return ((ConnectableComponentModel)componentModel).requiresConnection() && ExtensionConnectivityUtils.isConnectionProvisioningRequired((ExtensionModel)extensionModel, (ConnectableComponentModel)((ConnectableComponentModel)componentModel));
        }
        return false;
    }

    private static void addConnectionInterceptors(InterceptorChain.Builder chainBuilder, ExtensionConnectionSupplier connectionSupplier, ComponentTracer<CoreEvent> connectionComponentTracer) {
        chainBuilder.addInterceptor(new ConnectionInterceptor(connectionSupplier, connectionComponentTracer));
    }
}

