/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;

public class ResolverSetResult {
    private final Map<String, Object> evaluationResult;
    private final LazyValue<Integer> hashCode = new LazyValue(this::calculateHashCode);

    public static Builder newBuilder() {
        return new Builder();
    }

    ResolverSetResult(Map<String, Object> evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    public Object get(String parameterName) {
        return this.evaluationResult.get(parameterName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResolverSetResult) {
            ResolverSetResult other = (ResolverSetResult)obj;
            return this.evaluationResult.entrySet().stream().allMatch(entry -> Objects.equal(entry.getValue(), (Object)other.get((String)entry.getKey())));
        }
        return false;
    }

    public int hashCode() {
        return (Integer)this.hashCode.get();
    }

    private int calculateHashCode() {
        int hashcode = 1;
        for (Object val : this.evaluationResult.values()) {
            hashcode = 31 * hashcode + (val == null ? 0 : val.hashCode());
        }
        return hashcode;
    }

    public Map<String, Object> asMap() {
        return this.evaluationResult;
    }

    public static class Builder {
        LinkedHashMap<String, Object> values = new LinkedHashMap();

        Builder() {
        }

        public Builder add(String key, Object value) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"parameter cannot be null");
            this.values.put(key, value);
            return this;
        }

        public ResolverSetResult build() {
            return new ResolverSetResult(Collections.unmodifiableMap(this.values));
        }
    }
}

