/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.notification.NotificationActions;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.ExtensionDevelopmentFramework;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.ModelLoaderDelegateUtils;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ArtifactLifecycleListenerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExportedClassNamesModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.XmlDslConfiguration;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.ExportInfo;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.RequiresEnterpriseLicenseInfo;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.RequiresEntitlementInfo;
import org.mule.runtime.module.extension.internal.loader.parser.java.lib.JavaExternalLibModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.runtime.module.extension.internal.loader.utils.AnnotationsIntrospectorUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.sdk.api.annotation.ImportedTypes;
import org.mule.sdk.api.annotation.JavaVersionSupport;
import org.mule.sdk.api.annotation.OnArtifactLifecycle;
import org.mule.sdk.api.annotation.PrivilegedExport;
import org.mule.sdk.api.annotation.SubTypeMapping;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;
import org.mule.sdk.api.meta.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaExtensionModelParser
extends AbstractJavaModelParser
implements ExtensionModelParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaExtensionModelParser.class);
    private Optional<XmlDslConfiguration> xmlDslConfiguration;
    private List<ErrorModelParser> errorModelParsers;
    private final List<MetadataType> exportedTypes = new LinkedList<MetadataType>();
    private final List<String> exportedResources = new LinkedList<String>();
    private final ClassTypeLoader typeLoader;
    private final StereotypeModelLoaderDelegate stereotypeLoaderDelegate;
    private List<MetadataType> importedTypes = new LinkedList<MetadataType>();
    private List<String> privilegedExportedArtifacts = new LinkedList<String>();
    private List<String> privilegedExportedPackages = new LinkedList<String>();
    private List<NotificationModel> notificationModels = new LinkedList<NotificationModel>();
    private Map<MetadataType, List<MetadataType>> subTypes = new LinkedHashMap<MetadataType, List<MetadataType>>();
    private String namespace;
    private ResolvedMinMuleVersion resolvedMinMuleVersion;
    private Set<String> supportedJavaVersions;

    public JavaExtensionModelParser(ExtensionElement extensionElement, ExtensionLoadingContext loadingContext) {
        this(extensionElement, new StereotypeModelLoaderDelegate(loadingContext), loadingContext);
    }

    public JavaExtensionModelParser(ExtensionElement extensionElement, StereotypeModelLoaderDelegate stereotypeLoaderDelegate, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
        this.stereotypeLoaderDelegate = stereotypeLoaderDelegate;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(loadingContext.getExtensionClassLoader());
        this.parseStructure(extensionElement);
    }

    private void parseStructure(ExtensionElement extensionElement) {
        this.xmlDslConfiguration = this.parseXmlDslConfiguration();
        this.namespace = ExtensionNamespaceUtils.getExtensionsNamespace((XmlDslModel)ModelLoaderUtils.getXmlDslModel(extensionElement, "1.0.0", this.xmlDslConfiguration));
        this.stereotypeLoaderDelegate.setNamespace(this.namespace);
        this.errorModelParsers = this.fetchErrorModelParsers();
        this.additionalModelProperties.add(new ExtensionTypeDescriptorModelProperty(extensionElement));
        extensionElement.getDeclaringClass().ifPresent(extensionClass -> this.additionalModelProperties.add(new ImplementingTypeModelProperty((Class<?>)extensionClass)));
        this.parseExported();
        this.parseImportedTypes();
        this.parseSubtypes();
        this.parseNotificationModels();
        this.resolvedMinMuleVersion = this.mustResolveMinMuleVersion() ? MinMuleVersionUtils.resolveExtensionMinMuleVersion(extensionElement) : null;
        this.supportedJavaVersions = this.parseSupportedJavaVersions(extensionElement);
    }

    private Set<String> parseSupportedJavaVersions(ExtensionElement extensionElement) {
        return extensionElement.getValueFromAnnotation(JavaVersionSupport.class).map(a -> a.getEnumArrayValue(javaVersionSupport -> this.getJavaVersionSupport((JavaVersionSupport)javaVersionSupport, extensionElement)).stream().map(JavaVersion::version).collect(Collectors.toCollection(() -> new LinkedHashSet()))).orElse(Collections.emptySet());
    }

    private JavaVersion[] getJavaVersionSupport(JavaVersionSupport javaVersionSupport, ExtensionElement extensionElement) {
        try {
            return javaVersionSupport.value();
        }
        catch (EnumConstantNotPresentException e) {
            Class<?> annotatedClass = extensionElement.getDeclaringClass().orElseThrow(() -> new NoSuchElementException("No value present"));
            try {
                return AnnotationsIntrospectorUtils.extractJavaVersionValues(annotatedClass);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
    }

    private void parseSubtypes() {
        List<Pair> pairs = MuleExtensionAnnotationParser.mapReduceRepeatableAnnotation(this.extensionElement, org.mule.runtime.extension.api.annotation.SubTypeMapping.class, SubTypeMapping.class, container -> ((SubTypesMapping)container).value(), container -> ((org.mule.sdk.api.annotation.SubTypesMapping)container).value(), value -> new Pair((Object)value.getClassValue(sub -> sub.baseType()), value.getClassArrayValue(sub -> sub.subTypes())), value -> new Pair((Object)value.getClassValue(sub -> sub.baseType()), value.getClassArrayValue(sub -> sub.subTypes()))).collect(Collectors.toList());
        HashSet baseTypes = new HashSet();
        pairs.forEach(mapping -> {
            Type baseType = (Type)mapping.getFirst();
            baseTypes.add(baseType);
            MetadataType baseMetadataType = baseType.asMetadataType();
            Map subTypesMetadataTypes = ((List)mapping.getSecond()).stream().collect(Collectors.toMap(UnaryOperator.identity(), Type::asMetadataType, (u, v) -> {
                LOGGER.debug("Definition of type {} for base type {} is duplicated. It will be defined only once.", (Object)MetadataTypeUtils.getTypeId((MetadataType)u).orElse("Unknown"), (Object)MetadataTypeUtils.getTypeId((MetadataType)baseMetadataType).orElse("Unknown"));
                return u;
            }, LinkedHashMap::new));
            this.subTypes.put(baseMetadataType, new ArrayList(subTypesMetadataTypes.values()));
        });
    }

    private void parseNotificationModels() {
        this.notificationModels = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.extensionElement, NotificationActions.class, org.mule.sdk.api.annotation.notification.NotificationActions.class, value -> NotificationModelParserUtils.parseLegacyNotifications(value, this.namespace, this.typeLoader), value -> NotificationModelParserUtils.parseNotifications(value, this.namespace, this.typeLoader)).orElse(new LinkedList());
    }

    private void parseImportedTypes() {
        List types = MuleExtensionAnnotationParser.mapReduceRepeatableAnnotation(this.extensionElement, Import.class, org.mule.sdk.api.annotation.Import.class, container -> ((org.mule.runtime.extension.api.annotation.ImportedTypes)container).value(), container -> ((ImportedTypes)container).value(), value -> value.getClassValue(Import::type), value -> value.getClassValue(org.mule.sdk.api.annotation.Import::type)).collect(Collectors.toList());
        this.importedTypes = types.stream().distinct().map(Type::asMetadataType).collect(Collectors.toList());
        if (types.size() != this.importedTypes.size()) {
            throw new IllegalModelDefinitionException(String.format("There should be only one Import declaration for any given type in extension [%s]. Multiple imports of the same type are not allowed", this.getName()));
        }
    }

    private void parseExported() {
        ExportInfo info = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.extensionElement, Export.class, org.mule.sdk.api.annotation.Export.class, export -> ExportInfo.fromLegacy(export), export -> ExportInfo.fromSdkApi(export)).orElse(null);
        if (info == null) {
            return;
        }
        LinkedHashSet<String> exportedClassNames = new LinkedHashSet<String>();
        info.getExportedTypes().forEach(type -> {
            exportedClassNames.add(type.getClassInformation().getClassname());
            this.exportedTypes.add(type.asMetadataType());
        });
        this.exportedResources.addAll(info.getExportedResources());
        if (!exportedClassNames.isEmpty()) {
            this.additionalModelProperties.add(new ExportedClassNamesModelProperty(exportedClassNames));
        }
        this.parsePrivilegeExport();
    }

    private void parsePrivilegeExport() {
        MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.extensionElement, org.mule.runtime.extension.api.annotation.PrivilegedExport.class, PrivilegedExport.class, value -> new Pair(value.getArrayValue(org.mule.runtime.extension.api.annotation.PrivilegedExport::artifacts), value.getArrayValue(org.mule.runtime.extension.api.annotation.PrivilegedExport::packages)), value -> new Pair(value.getArrayValue(PrivilegedExport::artifacts), value.getArrayValue(PrivilegedExport::packages))).ifPresent(exported -> {
            this.privilegedExportedArtifacts = (List)exported.getFirst();
            this.privilegedExportedPackages = (List)exported.getSecond();
        });
    }

    @Override
    public String getName() {
        return this.extensionElement.getName();
    }

    @Override
    public Category getCategory() {
        return this.extensionElement.getCategory();
    }

    @Override
    public String getVendor() {
        return this.extensionElement.getVendor();
    }

    @Override
    public List<ConfigurationModelParser> getConfigurationParsers() {
        List<ConfigurationElement> configurations = this.extensionElement.getConfigurations();
        if (configurations.isEmpty()) {
            return Collections.singletonList(new JavaConfigurationModelParser(this, this.extensionElement, this.extensionElement, this.loadingContext));
        }
        return configurations.stream().map(config -> new JavaConfigurationModelParser(this, this.extensionElement, (ComponentElement)config, this.loadingContext)).collect(Collectors.toList());
    }

    @Override
    public List<OperationModelParser> getOperationModelParsers() {
        return JavaExtensionModelParserUtils.getOperationParsers(this, this.extensionElement, this.extensionElement, this.loadingContext).filter(operation -> !ModelLoaderDelegateUtils.requiresConfig(this.getDevelopmentFramework(), operation)).collect(Collectors.toList());
    }

    @Override
    public List<SourceModelParser> getSourceModelParsers() {
        return JavaExtensionModelParserUtils.getSourceParsers(this.extensionElement, this.extensionElement.getSources(), this.loadingContext).filter(source -> !ModelLoaderDelegateUtils.requiresConfig(source)).collect(Collectors.toList());
    }

    @Override
    public List<ConnectionProviderModelParser> getConnectionProviderModelParsers() {
        return JavaExtensionModelParserUtils.getConnectionProviderModelParsers(this, this.extensionElement, this.extensionElement.getConnectionProviders(), this.loadingContext);
    }

    @Override
    public List<FunctionModelParser> getFunctionModelParsers() {
        return JavaExtensionModelParserUtils.getFunctionModelParsers(this.extensionElement, this.extensionElement.getFunctionContainers(), this.loadingContext);
    }

    @Override
    public List<ErrorModelParser> getErrorModelParsers() {
        return this.errorModelParsers;
    }

    private List<ErrorModelParser> fetchErrorModelParsers() {
        return JavaErrorModelParserUtils.parseExtensionErrorModels(this.extensionElement, this.getNamespace());
    }

    @Override
    public LicenseModelProperty getLicenseModelProperty() {
        Optional<RequiresEntitlementInfo> requiresEntitlementOptional = JavaExtensionModelParserUtils.getRequiresEntitlementInfo(this.extensionElement);
        Optional<RequiresEnterpriseLicenseInfo> requiresEnterpriseLicenseOptional = JavaExtensionModelParserUtils.getRequiresEnterpriseLicenseInfo(this.extensionElement);
        boolean requiresEnterpriseLicense = requiresEnterpriseLicenseOptional.isPresent();
        boolean allowsEvaluationLicense = requiresEnterpriseLicenseOptional.map(RequiresEnterpriseLicenseInfo::isAllowEvaluationLicense).orElse(true);
        Optional<String> requiredEntitlement = requiresEntitlementOptional.map(RequiresEntitlementInfo::getName);
        return new LicenseModelProperty(requiresEnterpriseLicense, allowsEvaluationLicense, requiredEntitlement);
    }

    @Override
    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return JavaExternalLibModelParserUtils.parseExternalLibraryModels(this.extensionElement);
    }

    @Override
    public Optional<ExceptionHandlerModelProperty> getExtensionHandlerModelProperty() {
        return JavaErrorModelParserUtils.getExceptionHandlerModelProperty(this.extensionElement, "Extension", this.getName());
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.extensionElement);
    }

    @Override
    public Optional<XmlDslConfiguration> getXmlDslConfiguration() {
        return this.xmlDslConfiguration;
    }

    @Override
    public List<MetadataType> getExportedTypes() {
        return this.exportedTypes;
    }

    @Override
    public Map<MetadataType, List<MetadataType>> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public List<String> getExportedResources() {
        return this.exportedResources;
    }

    @Override
    public List<String> getPrivilegedExportedArtifacts() {
        return this.privilegedExportedArtifacts;
    }

    @Override
    public List<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    @Override
    public List<MetadataType> getImportedTypes() {
        return this.importedTypes;
    }

    @Override
    public List<NotificationModel> getNotificationModels() {
        return this.notificationModels;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Optional<ResolvedMinMuleVersion> getResolvedMinMuleVersion() {
        return Optional.ofNullable(this.resolvedMinMuleVersion);
    }

    @Override
    public ExtensionDevelopmentFramework getDevelopmentFramework() {
        return ExtensionDevelopmentFramework.JAVA_SDK;
    }

    @Override
    public Set<String> getSupportedJavaVersions() {
        return this.supportedJavaVersions;
    }

    @Override
    public Optional<ArtifactLifecycleListenerModelProperty> getArtifactLifecycleListenerModelProperty() {
        return this.parseArtifactLifecycleListener(this.extensionElement).map(ArtifactLifecycleListenerModelProperty::new);
    }

    public StereotypeModelLoaderDelegate getStereotypeLoaderDelegate() {
        return this.stereotypeLoaderDelegate;
    }

    private Optional<XmlDslConfiguration> parseXmlDslConfiguration() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.extensionElement, Xml.class, org.mule.sdk.api.annotation.dsl.xml.Xml.class, xml -> new XmlDslConfiguration(xml.getStringValue(Xml::prefix), xml.getStringValue(Xml::namespace)), xml -> new XmlDslConfiguration(xml.getStringValue(org.mule.sdk.api.annotation.dsl.xml.Xml::prefix), xml.getStringValue(org.mule.sdk.api.annotation.dsl.xml.Xml::namespace)));
    }

    private Optional<Class<? extends ArtifactLifecycleListener>> parseArtifactLifecycleListener(ExtensionElement extensionElement) {
        return extensionElement.getValueFromAnnotation(OnArtifactLifecycle.class).flatMap(this::parseArtifactLifecycleListener);
    }

    private Optional<Class<? extends ArtifactLifecycleListener>> parseArtifactLifecycleListener(AnnotationValueFetcher<OnArtifactLifecycle> annotationValueFetcher) {
        return annotationValueFetcher.getClassValue(OnArtifactLifecycle::value).getDeclaringClass().map(cls -> cls);
    }
}

